/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.tools;

import com.eviware.soapui.DefaultSoapUICore;
import com.eviware.soapui.SoapUI;
import com.eviware.soapui.SoapUICore;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.mock.DispatchException;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunner;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SoapUIMockServlet
extends HttpServlet {
    private WsdlMockRunner mockRunner;
    private WsdlMockService mockService;
    private WsdlProject project;
    private static Logger logger = Logger.getLogger(SoapUIMockServlet.class.getName());

    public void init() throws ServletException {
        super.init();
        try {
            logger.info("Initializing soapUI Core");
            SoapUI.setSoapUICore(this.createSoapUICore(this.getInitParameter("settingsFile"), this.getInitParameter("settingsPassword")), true);
            logger.info("Loading project");
            this.project = new WsdlProject(this.getInitParameter("projectFile"), this.getInitParameter("projectPassword"));
            logger.info("Starting MockService");
            this.mockService = this.project.getMockServiceByName(this.getInitParameter("mockService"));
            this.mockRunner = this.mockService.start();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.mockRunner.dispatchRequest(request, response);
        }
        catch (DispatchException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    public String getServletInfo() {
        return this.mockService.getName();
    }

    protected SoapUICore createSoapUICore(String settingsFile, String soapUISettingsPassword) {
        return new DefaultSoapUICore(null, settingsFile, soapUISettingsPassword);
    }
}

