/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ie.dom;

import com.jniwrapper.win32.automation.OleMessageLoop;
import com.jniwrapper.win32.ie.dom.HasDOMFactory;
import com.jniwrapper.win32.ie.dom.HasPeer;
import com.jniwrapper.win32.ie.dom.WrappedObject;
import com.jniwrapper.win32.ie.dom.i;
import com.jniwrapper.win32.ie.dom.j;
import com.jniwrapper.win32.ie.dom.k;
import com.jniwrapper.win32.ie.dom.l;
import com.jniwrapper.win32.ie.dom.m;
import java.awt.Dimension;
import java.awt.Point;
import java.util.concurrent.atomic.AtomicReference;
import org.w3c.dom.Element;
import org.w3c.dom.html.HTMLDocument;
import org.w3c.dom.html.HTMLElement;

public final class DOMUtils {
    public static int getVerticalScrollPosition(HTMLDocument hTMLDocument) {
        int n2 = DOMUtils.a("scrollTop", hTMLDocument.getBody());
        int n3 = DOMUtils.a("scrollTop", hTMLDocument.getDocumentElement());
        if (n2 == 0) {
            return n3;
        }
        return n2;
    }

    public static int getHorizontalScrollPosition(HTMLDocument hTMLDocument) {
        int n2 = DOMUtils.a("scrollLeft", hTMLDocument.getBody());
        int n3 = DOMUtils.a("scrollLeft", hTMLDocument.getDocumentElement());
        if (n2 == 0) {
            return n3;
        }
        return n2;
    }

    private static int a(String string, Element element) {
        if (element != null) {
            return Integer.parseInt(element.getAttribute(string));
        }
        return 0;
    }

    private static void a(String string, int n2, Element element) {
        element.setAttribute(string, Integer.toString(n2));
    }

    public static void scrollVertical(int n2, HTMLDocument hTMLDocument) {
        if (n2 < 0 || n2 > DOMUtils.getScrollHeight(hTMLDocument)) {
            throw new IllegalArgumentException("Scroll position should be non-negative, less or equal to maximum scroll position.");
        }
        DOMUtils.a("scrollTop", n2, hTMLDocument.getBody());
        DOMUtils.a("scrollTop", n2, hTMLDocument.getDocumentElement());
    }

    public static void scrollHorizontal(int n2, HTMLDocument hTMLDocument) {
        if (n2 < 0 || n2 > DOMUtils.getScrollWidth(hTMLDocument)) {
            throw new IllegalArgumentException("Scroll position should be non-negative, less or equal to maximum scroll position.");
        }
        DOMUtils.a("scrollLeft", n2, hTMLDocument.getBody());
        DOMUtils.a("scrollLeft", n2, hTMLDocument.getDocumentElement());
    }

    public static int getScrollHeight(HTMLDocument hTMLDocument) {
        int n2 = DOMUtils.a("scrollHeight", hTMLDocument.getBody());
        int n3 = DOMUtils.a("scrollHeight", hTMLDocument.getDocumentElement());
        return Math.max(n3, n2);
    }

    public static int getScrollWidth(HTMLDocument hTMLDocument) {
        int n2 = DOMUtils.a("scrollWidth", hTMLDocument.getBody());
        int n3 = DOMUtils.a("scrollWidth", hTMLDocument.getDocumentElement());
        return Math.max(n3, n2);
    }

    public static void setStyle(HTMLElement object, String string, String string2) {
        if (object instanceof WrappedObject && (object = ((WrappedObject)object).unwrap()) instanceof HasPeer) {
            object = (HasPeer)object;
            OleMessageLoop oleMessageLoop = object.getOleMessageLoop();
            try {
                oleMessageLoop.doInvokeAndWait(new i((HasPeer)object, string, string2));
                return;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public static String getStyle(HTMLElement object, String string) {
        AtomicReference<String> atomicReference = new AtomicReference<String>("");
        if (object instanceof WrappedObject && (object = ((WrappedObject)object).unwrap()) instanceof HasPeer) {
            object = (HasPeer)object;
            OleMessageLoop oleMessageLoop = object.getOleMessageLoop();
            try {
                oleMessageLoop.doInvokeAndWait(new j((HasPeer)object, string, atomicReference));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return atomicReference.get();
    }

    public static void click(Element object) {
        if (object instanceof WrappedObject && (object = ((WrappedObject)object).unwrap()) instanceof HasPeer) {
            object = (HasPeer)object;
            OleMessageLoop oleMessageLoop = object.getOleMessageLoop();
            try {
                oleMessageLoop.doInvokeAndWait(new k((HasPeer)object));
                return;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public static Point getLocation(Element element) {
        int n2 = Integer.parseInt(element.getAttribute("offsetLeft"));
        int n3 = Integer.parseInt(element.getAttribute("offsetTop"));
        return new Point(n2, n3);
    }

    public static Dimension getElementSize(Element element) {
        int n2 = Integer.parseInt(element.getAttribute("offsetWidth"));
        int n3 = Integer.parseInt(element.getAttribute("offsetHeight"));
        return new Dimension(n2, n3);
    }

    public static Point getAbsoluteLocation(Element element) {
        Point point = new Point(0, 0);
        do {
            Point point2 = DOMUtils.getLocation(element);
            point.x += point2.x;
            point.y += point2.y;
        } while ((element = DOMUtils.a(element)) != null && !"body".equalsIgnoreCase(element.getTagName()));
        return point;
    }

    public static HTMLElement getElementFromPoint(HTMLDocument object, Point point) {
        AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
        if (object instanceof WrappedObject && (object = ((WrappedObject)object).unwrap()) instanceof HasPeer) {
            HasPeer hasPeer = (HasPeer)object;
            OleMessageLoop oleMessageLoop = hasPeer.getOleMessageLoop();
            try {
                oleMessageLoop.doInvokeAndWait(new l(hasPeer, point, object, atomicReference));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return atomicReference.get();
    }

    private static HTMLElement a(Element object) {
        AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
        if (object instanceof WrappedObject && (object = ((WrappedObject)object).unwrap()) instanceof HasPeer && object instanceof HasDOMFactory) {
            HasPeer hasPeer = (HasPeer)object;
            OleMessageLoop oleMessageLoop = hasPeer.getOleMessageLoop();
            try {
                oleMessageLoop.doInvokeAndWait(new m(hasPeer, object, atomicReference));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return atomicReference.get();
    }
}

