/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.JavaScriptPage;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.PageCreator;
import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.UnexpectedPage;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.XHtmlPage;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import java.io.Serializable;

public class DefaultPageCreator
implements PageCreator,
Serializable {
    private static final long serialVersionUID = -4420355214574495577L;

    public Page createPage(WebResponse webResponse, WebWindow webWindow) throws IOException {
        XmlPage xml;
        DomElement doc;
        String contentType = webResponse.getContentType().toLowerCase();
        String pageType = this.determinePageType(contentType);
        Page newPage = pageType.equals("html") ? this.createHtmlPage(webResponse, webWindow) : (pageType.equals("javascript") ? this.createJavaScriptPage(webResponse, webWindow) : (pageType.equals("xml") ? ((doc = (xml = this.createXmlPage(webResponse, webWindow)).getDocumentElement()) != null && "http://www.w3.org/1999/xhtml".equals(doc.getNamespaceURI()) ? this.createXHtmlPage(webResponse, webWindow) : xml) : (pageType.equals("text") ? this.createTextPage(webResponse, webWindow) : this.createUnexpectedPage(webResponse, webWindow))));
        return newPage;
    }

    protected HtmlPage createHtmlPage(WebResponse webResponse, WebWindow webWindow) throws IOException {
        return HTMLParser.parseHtml(webResponse, webWindow);
    }

    protected XHtmlPage createXHtmlPage(WebResponse webResponse, WebWindow webWindow) throws IOException {
        return HTMLParser.parseXHtml(webResponse, webWindow);
    }

    protected JavaScriptPage createJavaScriptPage(WebResponse webResponse, WebWindow webWindow) {
        JavaScriptPage newPage = new JavaScriptPage(webResponse, webWindow);
        webWindow.setEnclosedPage(newPage);
        return newPage;
    }

    protected TextPage createTextPage(WebResponse webResponse, WebWindow webWindow) {
        TextPage newPage = new TextPage(webResponse, webWindow);
        webWindow.setEnclosedPage(newPage);
        return newPage;
    }

    protected UnexpectedPage createUnexpectedPage(WebResponse webResponse, WebWindow webWindow) {
        UnexpectedPage newPage = new UnexpectedPage(webResponse, webWindow);
        webWindow.setEnclosedPage(newPage);
        return newPage;
    }

    protected XmlPage createXmlPage(WebResponse webResponse, WebWindow webWindow) throws IOException {
        XmlPage newPage = new XmlPage(webResponse, webWindow);
        webWindow.setEnclosedPage(newPage);
        return newPage;
    }

    protected String determinePageType(String contentType) {
        if (contentType.equals("text/html") || contentType.equals("")) {
            return "html";
        }
        if (contentType.equals("text/javascript") || contentType.equals("application/x-javascript")) {
            return "javascript";
        }
        if (contentType.equals("text/xml") || contentType.equals("application/xml") || contentType.equals("text/vnd.wap.wml") || contentType.matches(".*\\+xml")) {
            return "xml";
        }
        if (contentType.startsWith("text/")) {
            return "text";
        }
        return "unknown";
    }
}

