/*
 * Decompiled with CFR 0.152.
 */
package hermes;

import hermes.Hermes;
import hermes.HermesException;
import hermes.HermesLoader;
import hermes.impl.jms.ContextImpl;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class HermesContext
extends ContextImpl {
    private static final Logger log = Logger.getLogger(HermesContext.class);
    public static final String FACTORIES = "/conf/factories";
    public static final String LOADER = "/conf/loader";
    public static final String CONFIG = "/conf/hermes";
    private HermesLoader loader;

    public HermesContext(Hashtable environment, HermesLoader loader) throws NamingException {
        super(environment);
        this.loader = loader;
    }

    public void load() throws NamingException {
        try {
            for (Hermes hermes : this.loader.load()) {
                try {
                    Hermes old = (Hermes)this.lookup(hermes.getId());
                    try {
                        old.close();
                    }
                    catch (JMSException ex) {
                        log.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
                this.bind(hermes.getId(), (Object)hermes);
            }
            this.bind(LOADER, (Object)this.loader);
            this.bind(CONFIG, (Object)this.loader.getConfig());
        }
        catch (HermesException e) {
            log.error((Object)e.getMessage(), (Throwable)((Object)e));
            throw new NamingException(e.getMessage());
        }
    }
}

