/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.components;

import com.jidesoft.grid.HierarchicalTable;
import hermes.browser.HermesBrowser;
import hermes.browser.dialog.PreferencesDialog;
import hermes.browser.model.ClasspathGroupTableModel;
import hermes.config.ClasspathGroupConfig;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ClasspathGroupTable
extends HierarchicalTable {
    private static final Logger log = Logger.getLogger(ClasspathGroupTable.class);
    private ClasspathGroupTableModel model;
    private PreferencesDialog dialog;
    private MouseAdapter mouseAdapter;

    public ClasspathGroupTable(PreferencesDialog dialog, ClasspathGroupTableModel model) {
        super((TableModel)model);
        this.dialog = dialog;
        this.model = model;
        this.setComponentFactory(model);
        this.init();
    }

    public ClasspathGroupTable(PreferencesDialog dialog) {
        this(dialog, null);
    }

    public ClasspathGroupTableModel getClasspathGroupTableModel() {
        return this.model;
    }

    public void setModel(TableModel model) {
        super.setModel(model);
        this.model = (ClasspathGroupTableModel)model;
        this.setComponentFactory((ClasspathGroupTableModel)model);
    }

    public MouseAdapter getMouseAdapter() {
        return this.mouseAdapter;
    }

    private void init() {
        final JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem addItem = new JMenuItem("Add Group");
        final JMenuItem removeItem = new JMenuItem("Remove Group");
        final JMenuItem renameItem = new JMenuItem("Rename");
        popupMenu.add(addItem);
        popupMenu.add(removeItem);
        popupMenu.add(renameItem);
        addItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                try {
                    ClasspathGroupTable.this.doAddGroup();
                    ClasspathGroupTable.this.dialog.setDirty();
                }
                catch (Exception ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        });
        removeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (ClasspathGroupTable.this.getSelectedRowCount() > 0) {
                    for (int row : ClasspathGroupTable.this.getSelectedRows()) {
                        ClasspathGroupTable.this.getClasspathGroupTableModel().removeRow(row);
                    }
                    ClasspathGroupTable.this.dialog.setDirty();
                }
            }
        });
        renameItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ClasspathGroupTable.this.getSelectedRow() != -1) {
                    ClasspathGroupTable.this.doRename();
                }
            }
        });
        this.mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    removeItem.setEnabled(ClasspathGroupTable.this.getClasspathGroupTableModel().getRowCount() != 0);
                    renameItem.setEnabled(ClasspathGroupTable.this.getClasspathGroupTableModel().getRowCount() != 0);
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        this.addMouseListener(this.mouseAdapter);
        this.getTableHeader().addMouseListener(this.mouseAdapter);
        if (this.dialog != null) {
            this.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("tableCellEditor")) {
                        ClasspathGroupTable.this.dialog.setDirty();
                    }
                }
            });
        }
    }

    public void doRename() {
        ClasspathGroupConfig config = this.getClasspathGroupTableModel().getRow(this.getSelectedRow());
        String name = JOptionPane.showInputDialog((Component)((Object)HermesBrowser.getBrowser()), "New name:", config.getId());
        if (!config.getId().equals(name)) {
            config.setId(name);
            this.dialog.setDirty();
        }
    }

    public void doAddGroup() {
        String name = JOptionPane.showInputDialog((Component)((Object)HermesBrowser.getBrowser()), "Classpath group name:", "");
        if (!StringUtils.isEmpty((String)name)) {
            ClasspathGroupConfig config = new ClasspathGroupConfig();
            config.setId(name);
            this.getClasspathGroupTableModel().addRow(config);
            this.expandRow(this.getClasspathGroupTableModel().getRowCount() - 1);
        }
    }
}

