/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.dialog;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.StandardDialog;
import com.jidesoft.swing.JideScrollPane;
import hermes.Domain;
import hermes.Hermes;
import hermes.JNDIConnectionFactory;
import hermes.JNDIContextFactory;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.dialog.BindToolTable;
import hermes.browser.model.BindToolTableModel;
import hermes.swing.SwingRunner;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashSet;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import org.apache.log4j.Logger;

public class BindToolDialog
extends StandardDialog {
    private static final long serialVersionUID = 3257845467864707890L;
    private static final Logger log = Logger.getLogger(BindToolDialog.class);
    private Collection nodes;
    private BindToolTableModel bindModel;
    private JNDIContextFactory contextFactory;
    private String bindingRoot;

    public BindToolDialog(Frame frame, JNDIContextFactory contextFactory, String bindingRoot, Collection nodes) {
        super(frame, "JNDI BindTool", true);
        this.nodes = nodes;
        this.contextFactory = contextFactory;
        this.bindingRoot = bindingRoot;
        this.setDefaultAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                BindToolDialog.this.doBind();
            }
        });
    }

    private void doBind() {
        final ProgressMonitor monitor = new ProgressMonitor((Component)((Object)HermesBrowser.getBrowser()), "Binding objects...", "Starting.", 0, this.bindModel.getRowCount() * 2);
        monitor.setMillisToDecideToPopup(100);
        monitor.setMillisToPopup(400);
        HermesBrowser.getBrowser().getThreadPool().invokeLater(new Runnable(){

            public void run() {
                try {
                    BindToolDialog.this.doBindAsync(monitor);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    HermesBrowser.getBrowser().showErrorDialog(e);
                }
            }
        });
    }

    private void doBindAsync(final ProgressMonitor monitor) throws NamingException, JMSException {
        final HashSet closeHermes = new HashSet();
        this.bindModel.visit(new BindToolTableModel.Visitor(){
            boolean keepRunning = true;
            int progress = 0;

            public void onDestination(Hermes hermes, final String destinationName, Domain domain, final String binding) {
                if (this.keepRunning) {
                    closeHermes.add(hermes);
                    try {
                        SwingRunner.invokeLater(new Runnable(){

                            public void run() {
                                monitor.setProgress(++progress);
                                monitor.setNote("Creating destination " + destinationName);
                            }
                        });
                        Destination destination = hermes.getDestination(destinationName, domain);
                        SwingRunner.invokeLater(new Runnable(){

                            public void run() {
                                monitor.setProgress(++progress);
                                monitor.setNote("Binding " + destinationName + " at " + binding);
                            }
                        });
                        log.debug((Object)("binding destination " + destinationName + " at " + binding));
                        Context context = BindToolDialog.this.contextFactory.createContext();
                        context.bind(binding, (Object)destination);
                        context.close();
                    }
                    catch (Throwable e) {
                        this.handleError(e);
                    }
                }
            }

            public void onHermes(final Hermes hermes, final String binding) {
                if (this.keepRunning) {
                    closeHermes.add(hermes);
                    try {
                        SwingRunner.invokeLater(new Runnable(){

                            public void run() {
                                monitor.setProgress(++progress);
                                monitor.setNote("Creating connection factory from session " + hermes.getId());
                            }
                        });
                        ConnectionFactory connectionFactory = hermes.getConnectionFactory();
                        if (connectionFactory instanceof JNDIConnectionFactory) {
                            connectionFactory = ((JNDIConnectionFactory)connectionFactory)._getConnectionFactory();
                        }
                        SwingRunner.invokeLater(new Runnable(){

                            public void run() {
                                monitor.setProgress(++progress);
                                monitor.setNote("Binding " + hermes.getId() + " at " + binding);
                            }
                        });
                        log.debug((Object)("binding connection factory from Hermes " + hermes.getId() + " at " + binding));
                        Context context = BindToolDialog.this.contextFactory.createContext();
                        context.bind(binding, (Object)connectionFactory);
                        context.close();
                    }
                    catch (Throwable e) {
                        this.handleError(e);
                    }
                }
            }

            public void handleError(Throwable t) {
                log.error((Object)t.getMessage(), t);
                if (JOptionPane.showConfirmDialog((Component)((Object)HermesBrowser.getBrowser()), t.getClass().getName() + "\n" + (t.getMessage() == null ? "Provider gave no message " : t.getMessage()) + "- do you want to continue?", "Error", 0) == 1) {
                    this.keepRunning = false;
                }
            }
        });
        for (Hermes hermes : closeHermes) {
            try {
                hermes.close();
            }
            catch (JMSException e) {
                log.error((Object)("closing Hermes " + hermes.getId() + ": " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public JComponent createBannerPanel() {
        JLabel label = new JLabel(IconCache.getIcon("hermes/browser/icons/jndi_large.gif"), 4);
        return label;
    }

    public ButtonPanel createButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        JButton okButton = new JButton("Bind");
        JButton cancelButton = new JButton("Cancel");
        buttonPanel.addButton((AbstractButton)okButton);
        buttonPanel.addButton((AbstractButton)cancelButton);
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BindToolDialog.this.doBind();
                BindToolDialog.this.dispose();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BindToolDialog.this.dispose();
            }
        });
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        return buttonPanel;
    }

    public JComponent createContentPanel() {
        this.bindModel = new BindToolTableModel(this.nodes, this.bindingRoot);
        BindToolTable table = new BindToolTable(this.bindModel);
        JideScrollPane rval = new JideScrollPane();
        rval.setViewportView((Component)((Object)table));
        return rval;
    }
}

