/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.dialog;

import com.jidesoft.grid.ContextSensitiveCellEditor;
import com.jidesoft.grid.EditorContext;
import hermes.HermesException;
import hermes.browser.HermesBrowser;
import hermes.config.ClasspathGroupConfig;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JTable;
import org.apache.commons.collections.map.LRUMap;
import org.apache.log4j.Logger;

public class ClasspathIdCellEdtitor
extends ContextSensitiveCellEditor {
    private static final Logger log = Logger.getLogger(ClasspathIdCellEdtitor.class);
    public static final EditorContext CONTEXT = new EditorContext("ClasspathId");
    private String selection = "System";
    private Map tableToCombo = new LRUMap(10);

    public Component getTableCellEditorComponent(JTable table, Object value, boolean arg2, int arg3, int arg4) {
        try {
            if (this.tableToCombo.containsKey(table)) {
                return (Component)this.tableToCombo.get(table);
            }
            Vector<String> items = new Vector<String>();
            for (ClasspathGroupConfig config : HermesBrowser.getBrowser().getConfig().getClasspathGroup()) {
                items.add(config.getId());
            }
            items.add("System");
            final JComboBox combo = new JComboBox(items);
            combo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    ClasspathIdCellEdtitor.this.selection = (String)combo.getSelectedItem();
                }
            });
            if (value != null) {
                combo.setSelectedItem(value);
            }
            log.debug((Object)("value=" + value));
            this.tableToCombo.put(table, combo);
            return combo;
        }
        catch (HermesException e) {
            log.error((Object)e.getMessage(), (Throwable)((Object)e));
            return table;
        }
    }

    public Object getCellEditorValue() {
        return this.selection;
    }
}

