/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.dialog;

import hermes.browser.ConfigDialogProxy;
import hermes.browser.HermesBrowser;
import hermes.browser.MessageRenderer;
import hermes.browser.dialog.AbstractRendererConfigPanel;
import hermes.browser.dialog.PreferencesDialog;
import hermes.browser.model.ListConfigTableModel;
import hermes.config.HermesConfig;
import hermes.config.RendererConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;

public class GeneralRendererConfigPanel
extends AbstractRendererConfigPanel {
    private static final Logger log = Logger.getLogger(GeneralRendererConfigPanel.class);
    private JScrollPane bottomSP = new JScrollPane();
    private JTable classTable = new JTable();
    private Map configChanges = new HashMap();
    private ListConfigTableModel configModel;
    private PreferencesDialog dialog;
    private HermesConfig hermesConfig;
    private JLabel infoLabel1 = new JLabel();
    private Set newLoaderConfigs = new HashSet();
    private JSplitPane splitPane = new JSplitPane(0);
    private JScrollPane topSP = new JScrollPane();

    public GeneralRendererConfigPanel(PreferencesDialog dialog) {
        this.dialog = dialog;
        this.init();
    }

    public void doRendererSelected(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting() && this.classTable.getSelectedRow() >= 0) {
            String rendererName = (String)this.configModel.getValueAt(this.classTable.getSelectedRow(), 0);
            try {
                MessageRenderer renderer = HermesBrowser.getRendererManager().getRendererByName(rendererName);
                ConfigDialogProxy proxy = (ConfigDialogProxy)this.configChanges.get(renderer.getClass().getName());
                JComponent configPanel = null;
                if (proxy != null && (configPanel = renderer.getConfigPanel(proxy)) != null) {
                    this.bottomSP.setViewportView(configPanel);
                    this.configChanges.put(renderer.getClass().getName(), proxy);
                } else {
                    this.bottomSP.setViewportView(new JLabel("No properties"));
                }
            }
            catch (Exception ex) {
                this.add((Component)new JLabel(ex.getMessage()), "South");
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private void init() {
        Border border = BorderFactory.createBevelBorder(0);
        JPanel topPanel = new JPanel();
        topPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        topPanel.setLayout(new GridLayout(1, 2));
        this.infoLabel1.setText("Message Renderers");
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(border, "Renderers"));
        topPanel.add(this.infoLabel1);
        this.topSP.setViewportView(this.classTable);
        this.classTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.add((Component)topPanel, "North");
        this.add((Component)this.splitPane, "Center");
        this.splitPane.add((Component)this.topSP, "top");
        this.splitPane.add((Component)this.bottomSP, "bottom");
        this.splitPane.setDividerLocation(200);
        this.classTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                GeneralRendererConfigPanel.this.doRendererSelected(e);
            }
        });
    }

    public void initState() {
        this.configChanges.clear();
        for (MessageRenderer renderer : HermesBrowser.getRendererManager().getRenderers()) {
            try {
                String className = renderer.getClass().getName();
                Map properties = BeanUtils.describe((Object)renderer);
                final MessageRenderer.Config rendererConfig = renderer.createConfig();
                if (rendererConfig == null) continue;
                BeanUtils.populate((Object)rendererConfig, (Map)properties);
                ConfigDialogProxy proxy = new ConfigDialogProxy(){

                    public MessageRenderer.Config getConfig() {
                        return rendererConfig;
                    }

                    public void setDirty() {
                        GeneralRendererConfigPanel.this.dialog.setDirty();
                    }
                };
                this.configChanges.put(className, proxy);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setHermesConfig(HermesConfig hermesConfig) {
        this.hermesConfig = hermesConfig;
        this.initState();
        this.configModel = new ListConfigTableModel();
        for (MessageRenderer rConfig : HermesBrowser.getRendererManager().getRenderers()) {
            this.configModel.addItem(rConfig.getDisplayName());
        }
        this.classTable.setModel(this.configModel);
        DefaultTableColumnModel cm = new DefaultTableColumnModel();
        cm.addColumn(new TableColumn());
        this.classTable.setColumnModel(cm);
    }

    public void updateModel() {
        if (this.configModel != null && this.hermesConfig != null) {
            this.hermesConfig.getRenderer().clear();
            Iterator iter = this.configModel.getRows().iterator();
            while (iter.hasNext()) {
                RendererConfig rConfig = new RendererConfig();
                MessageRenderer renderer = HermesBrowser.getRendererManager().getRendererByName((String)iter.next());
                rConfig.setClassName(renderer.getClass().getName());
                this.hermesConfig.getRenderer().add(rConfig);
                ConfigDialogProxy proxy = (ConfigDialogProxy)this.configChanges.get(rConfig.getClassName());
                if (proxy == null) continue;
                try {
                    Map props = BeanUtils.describe((Object)proxy.getConfig());
                    HermesBrowser.getConfigDAO().setRendererProperties(this.hermesConfig, rConfig.getClassName(), props);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

