/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.dialog;

import com.jidesoft.grid.SortableTable;
import com.jidesoft.swing.JideScrollPane;
import hermes.HermesAdminFactory;
import hermes.SingletonManager;
import hermes.browser.HermesBrowser;
import hermes.browser.dialog.PreferencesDialog;
import hermes.browser.model.PropertySetTableModel;
import hermes.config.ProviderExtConfig;
import hermes.impl.ClassLoaderManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.xml.bind.JAXBException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;

public class HermesAdminFactoryConfigPanel
extends JPanel {
    private static final Logger log = Logger.getLogger(HermesAdminFactoryConfigPanel.class);
    private static final String ADMIN_FACTORY = "Plug In";
    private static final String REMOVE_PROPERTY = "Remove property";
    private static final String ADD_PROPERTY = "Add property";
    private static final Category cat = Category.getInstance(HermesAdminFactoryConfigPanel.class);
    private PreferencesDialog dialog;
    private ProviderExtConfig config;
    private SortableTable propertyTable = new SortableTable();
    private JComboBox afCombo = new JComboBox();
    private JideScrollPane propertyTableSP = new JideScrollPane();
    private JComboBox propertySelectionComboBox;
    private DefaultComboBoxModel cfComboModel = new DefaultComboBoxModel();
    private PropertySetTableModel propertyTableModel;
    private HermesAdminFactory bean;
    private JPopupMenu popupMenu = new JPopupMenu();
    private JMenuItem addItem = new JMenuItem("Add property");
    private JMenuItem removeItem = new JMenuItem("Remove property");

    public HermesAdminFactoryConfigPanel(PreferencesDialog dialog) {
        this.dialog = dialog;
        this.init();
    }

    public void init() {
        Border border = BorderFactory.createBevelBorder(0);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(border, ADMIN_FACTORY));
        this.afCombo.setModel(this.cfComboModel);
        this.propertyTableSP.setViewportView((Component)this.propertyTable);
        this.propertyTable.setSortable(true);
        this.add((Component)this.afCombo, "North");
        this.add((Component)this.propertyTableSP, "Center");
        this.popupMenu.add(this.addItem);
        this.popupMenu.add(this.removeItem);
        this.addItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                try {
                    HermesAdminFactoryConfigPanel.this.propertyTableModel.insertRow();
                }
                catch (Exception ex) {
                    cat.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        });
        this.removeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (HermesAdminFactoryConfigPanel.this.propertyTable.getSelectedRow() != -1) {
                    HermesAdminFactoryConfigPanel.this.propertyTableModel.removeRow(HermesAdminFactoryConfigPanel.this.propertyTable.getSelectedRow());
                }
            }
        });
        MouseAdapter m = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    if (e.getComponent() == HermesAdminFactoryConfigPanel.this.propertyTableSP) {
                        HermesAdminFactoryConfigPanel.this.removeItem.setEnabled(false);
                    } else {
                        HermesAdminFactoryConfigPanel.this.removeItem.setEnabled(true);
                    }
                    if (HermesAdminFactoryConfigPanel.this.propertySelectionComboBox.getModel().getSize() == 0) {
                        HermesAdminFactoryConfigPanel.this.addItem.setEnabled(false);
                    } else {
                        HermesAdminFactoryConfigPanel.this.addItem.setEnabled(true);
                    }
                    HermesAdminFactoryConfigPanel.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        this.propertyTableSP.addMouseListener((MouseListener)m);
        this.propertyTable.addMouseListener((MouseListener)m);
        this.propertyTable.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        this.cfComboModel.addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent arg0) {
                String className = HermesBrowser.getConfigDAO().getAdminClassForPlugIn((String)HermesAdminFactoryConfigPanel.this.cfComboModel.getSelectedItem());
                ClassLoaderManager classLoaderManager = (ClassLoaderManager)SingletonManager.get(ClassLoaderManager.class);
                try {
                    if (HermesAdminFactoryConfigPanel.this.propertyTableModel != null) {
                        ClassLoader classLoader = classLoaderManager.getClassLoader(HermesAdminFactoryConfigPanel.this.dialog.getSelectedLoader());
                        Thread.currentThread().setContextClassLoader(classLoader);
                        HermesAdminFactoryConfigPanel.this.bean = (HermesAdminFactory)classLoader.loadClass(className).newInstance();
                        HermesAdminFactoryConfigPanel.this.propertyTableModel.setBean(HermesAdminFactoryConfigPanel.this.bean);
                        HermesAdminFactoryConfigPanel.this.updateCellEditor();
                        HermesAdminFactoryConfigPanel.this.dialog.setDirty();
                    }
                }
                catch (Throwable e) {
                    HermesBrowser.getBrowser().showErrorDialog("Unable to locate this plugin.\nSelect the loader the JMS provider classes are in before choosing the plugin.");
                    HermesAdminFactoryConfigPanel.this.cfComboModel.setSelectedItem("Default");
                }
            }

            public void intervalAdded(ListDataEvent arg0) {
            }

            public void intervalRemoved(ListDataEvent arg0) {
            }
        });
    }

    public void setConfig(String classPathId, ProviderExtConfig newConfig) {
        this.config = newConfig;
        if (this.cfComboModel.getIndexOf("Default") == -1) {
            this.cfComboModel.addElement("Default");
        }
        for (String adminFactoryName : HermesBrowser.getConfigDAO().getAdminFactories()) {
            String pluginName = HermesBrowser.getConfigDAO().getPlugInName(adminFactoryName);
            if (this.cfComboModel.getIndexOf(pluginName) != -1) continue;
            this.cfComboModel.addElement(pluginName);
        }
        this.cfComboModel.setSelectedItem(HermesBrowser.getConfigDAO().getPlugInName(this.config.getClassName()));
        try {
            ClassLoaderManager classLoaderManager = (ClassLoaderManager)SingletonManager.get(ClassLoaderManager.class);
            ClassLoader classLoader = classLoaderManager.getClassLoader(classPathId);
            Thread.currentThread().setContextClassLoader(classLoader);
            this.bean = (HermesAdminFactory)classLoader.loadClass(this.config.getClassName()).newInstance();
        }
        catch (Throwable e) {
            cat.error((Object)e.getMessage(), e);
        }
        try {
            this.propertyTableModel = new PropertySetTableModel(this.bean, this.config.getProperties(), new HashSet());
            this.propertyTable.setModel((TableModel)this.propertyTableModel);
            this.updateCellEditor();
            if (this.propertyTableModel.getProperties().size() == 0) {
                this.addItem.setEnabled(false);
                this.removeItem.setEnabled(false);
            }
        }
        catch (Throwable ex) {
            cat.error((Object)ex.getMessage(), ex);
        }
        this.propertyTableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent arg0) {
                HermesAdminFactoryConfigPanel.this.dialog.setDirty();
            }
        });
    }

    public void updateCellEditor() throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (this.propertyTable.getColumnModel().getColumnCount() > 0) {
            TableColumn propertyNameColumn = this.propertyTable.getColumnModel().getColumn(0);
            this.propertySelectionComboBox = new JComboBox();
            boolean isJNDI = false;
            try {
                Map properties = BeanUtils.describe((Object)this.bean);
                log.debug((Object)("bean= " + properties));
                for (String name : this.propertyTableModel.getValidProperties()) {
                    this.propertySelectionComboBox.addItem(name);
                }
            }
            catch (InvocationTargetException e) {
                cat.error((Object)e.getTargetException().getMessage(), e.getTargetException());
            }
            propertyNameColumn.setCellEditor(new DefaultCellEditor(this.propertySelectionComboBox));
        }
    }

    public void updateModel() {
        if (this.propertyTableModel != null && this.config != null) {
            try {
                this.config.setClassName(HermesBrowser.getConfigDAO().getAdminClassForPlugIn(this.afCombo.getSelectedItem().toString()));
                this.config.getProperties().getProperty().clear();
                this.config.getProperties().getProperty().addAll(this.propertyTableModel.getProperties());
            }
            catch (JAXBException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

