/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.model;

import hermes.config.ClasspathConfig;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;

public class ClasspathConfigTableModel
extends DefaultTableModel {
    private static final Logger log = Logger.getLogger(ClasspathConfigTableModel.class);
    private List rows;

    public ClasspathConfigTableModel(List rows) {
        this.addColumn("Library");
        this.addColumn("ConnectionFactory");
        this.rows = rows;
    }

    public ClasspathConfig getRowAt(int row) {
        return (ClasspathConfig)this.rows.get(row);
    }

    public int getColumnCount() {
        return 1;
    }

    public int getRowCount() {
        if (this.rows == null) {
            return 0;
        }
        return this.rows.size();
    }

    public Object getValueAt(int y, int x) {
        ClasspathConfig cConfig = (ClasspathConfig)this.rows.get(y);
        if (x == 0) {
            return cConfig.getJar();
        }
        return new Boolean(cConfig.isNoFactories() == false);
    }

    public boolean isCellEditable(int y, int x) {
        return false;
    }

    public void setValueAt(Object value, int y, int x) {
        ClasspathConfig cConfig = (ClasspathConfig)this.rows.get(y);
        log.debug((Object)("value=" + value));
        if (x == 0) {
            cConfig.setJar((String)value);
        } else {
            cConfig.setNoFactories((boolean)((Boolean)value));
        }
        this.fireTableRowsUpdated(y, y);
    }

    public void removeRow(int y) {
        Object element = this.rows.remove(y);
        this.fireTableRowsDeleted(y, y);
    }

    public void addItem(ClasspathConfig cConfig) {
        if (this.rows.indexOf(cConfig.getJar()) == -1) {
            this.rows.add(cConfig);
            this.fireTableRowsInserted(this.rows.size() - 1, this.rows.size());
        }
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        return Boolean.class;
    }
}

