/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.model;

import hermes.Domain;
import hermes.config.DestinationConfig;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;

public class DestinationConfigTableModel
extends DefaultTableModel {
    private static final Logger log = Logger.getLogger(DestinationConfigTableModel.class);
    private Vector rows = new Vector();
    private Map queues = new HashMap();
    private Map topics = new HashMap();

    public DestinationConfigTableModel(List dList) {
        this.addColumn("Name");
        this.addColumn("ShortName");
        this.addColumn("Domain");
        for (DestinationConfig dConfig : dList) {
            this.addItem(dConfig);
        }
    }

    public DestinationConfig getConfig(String name, Domain domain) {
        if (domain == Domain.QUEUE) {
            return (DestinationConfig)this.queues.get(name);
        }
        return (DestinationConfig)this.topics.get(name);
    }

    public boolean hasConfig(String name) {
        return this.queues.containsKey(name) || this.topics.containsKey(name);
    }

    public Collection getRows() {
        return this.rows;
    }

    public int getColumnCount() {
        return 3;
    }

    public int getRowCount() {
        if (this.rows != null) {
            return this.rows.size();
        }
        return 0;
    }

    public Object getValueAt(int y, int x) {
        DestinationConfig dConfig = (DestinationConfig)this.rows.elementAt(y);
        switch (x) {
            case 0: {
                return dConfig.getName();
            }
            case 1: {
                return dConfig.getShortName();
            }
            case 2: {
                if (dConfig.getDomain().intValue() == Domain.QUEUE.getId()) {
                    return "QUEUE";
                }
                return "TOPIC";
            }
        }
        return null;
    }

    public boolean isCellEditable(int y, int x) {
        return false;
    }

    public void setValueAt(Object value, int y, int x) {
    }

    public void removeRow(int y) {
        DestinationConfig dConfig = (DestinationConfig)this.rows.elementAt(y);
        this.rows.remove(dConfig);
        if (dConfig.getDomain().intValue() == Domain.QUEUE.getId()) {
            this.queues.remove(dConfig);
        } else {
            this.topics.remove(dConfig);
        }
        this.fireTableDataChanged();
    }

    public DestinationConfig getRowConfig(int row) {
        return (DestinationConfig)this.rows.elementAt(row);
    }

    public void addItem(DestinationConfig dConfig) {
        if (dConfig != null && dConfig.getName() != null && !dConfig.getName().equals("")) {
            Map configs;
            Map map = configs = dConfig.getDomain().intValue() == Domain.QUEUE.getId() ? this.queues : this.topics;
            if (configs.containsKey(dConfig.getName())) {
                configs.put(dConfig.getName(), dConfig);
                Iterator iter = this.rows.iterator();
                while (iter.hasNext()) {
                    DestinationConfig row = (DestinationConfig)iter.next();
                    if (!row.getName().equals(dConfig.getName())) continue;
                    iter.remove();
                }
                this.rows.add(dConfig);
            } else {
                this.rows.add(dConfig);
                configs.put(dConfig.getName(), dConfig);
            }
            this.fireTableRowsInserted(this.rows.size(), this.rows.size());
        }
    }

    public Collection getDestinations() {
        return this.rows;
    }

    public void refresh() {
        this.fireTableDataChanged();
    }
}

