/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.tasks;

import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.actions.FIXSessionBrowserDocumentComponent;
import hermes.browser.tasks.TaskSupport;
import hermes.fix.FIXMessage;
import hermes.fix.FIXMessageFilter;
import hermes.fix.FIXReader;
import hermes.fix.quickfix.FIXInputStreamReader;
import hermes.fix.quickfix.NIOFIXFileReader;
import hermes.util.TextUtils;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class BrowseFIXFileTask
extends TaskSupport {
    private static final Logger log = Logger.getLogger(BrowseFIXFileTask.class);
    private InputStream istream;
    private String title;
    private FIXSessionBrowserDocumentComponent frame;
    private FIXReader reader;

    public BrowseFIXFileTask(FIXSessionBrowserDocumentComponent frame, InputStream istream, String title) {
        super(IconCache.getIcon("hermes.file.fix"));
        this.istream = istream;
        this.title = title;
        this.frame = frame;
    }

    public String getTitle() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() throws Exception {
        int nmessages = 0;
        this.reader = this.istream instanceof FileInputStream ? new NIOFIXFileReader(this.frame.getMessageCache(), (FileInputStream)this.istream) : new FIXInputStreamReader(this.frame.getMessageCache(), this.istream);
        if (HermesBrowser.getBrowser().getConfig().getQuickFIX().isFilterSessionMsgTypes().booleanValue()) {
            this.reader.getFilter().add(FIXMessageFilter.SESSION_MSGTYPES);
        }
        try {
            FIXMessage message;
            while (this.isRunning() && (message = this.reader.read()) != null) {
                ++nmessages;
                this.frame.addMessage(message);
            }
        }
        catch (Throwable ex) {
            log.error((Object)("browse stopped: " + ex.getMessage()));
        }
        finally {
            this.reader.close();
            log.debug((Object)("nmessages=" + nmessages));
        }
        this.notifyStatus("Read " + nmessages + " message" + TextUtils.plural(nmessages) + " from " + this.title);
    }
}

