/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.tasks;

import hermes.Domain;
import hermes.Hermes;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.model.tree.DestinationConfigTreeNode;
import hermes.browser.tasks.TaskSupport;
import hermes.store.MessageStore;
import java.awt.Component;
import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.QueueBrowser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class RecordDestinationTask
extends TaskSupport {
    private Hermes hermes;
    private DestinationConfigTreeNode node;
    private MessageStore messageStore;

    public RecordDestinationTask(Hermes hermes, DestinationConfigTreeNode node, MessageStore messageStore) {
        super(node.getDomain() == Domain.QUEUE ? IconCache.getIcon("hermes.queue.record") : IconCache.getIcon("hermes.topic.record"));
        this.hermes = hermes;
        this.node = node;
        this.messageStore = messageStore;
    }

    public String getTitle() {
        return "Recording " + this.node.getDestinationName() + " into " + this.messageStore.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() throws Exception {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JOptionPane.showMessageDialog((Component)((Object)HermesBrowser.getBrowser()), RecordDestinationTask.this.getTitle() + ", click on the Tools tab to see running tasks.", "Running", 1);
                }
            });
            Hermes.ui.getDefaultMessageSink().add(this.getTitle());
            Destination d = this.hermes.getDestination(this.node.getDestinationName(), this.node.getDomain());
            QueueBrowser browser = this.hermes.createBrowser(this.node.getConfig());
            Enumeration iter = browser.getEnumeration();
            while (iter.hasMoreElements() && this.isRunning()) {
                Message m = (Message)iter.nextElement();
                if (m == null) continue;
                this.messageStore.store(m);
                this.messageStore.checkpoint();
            }
            this.messageStore.checkpoint();
            browser.close();
            this.hermes.close();
        }
        finally {
            Hermes.ui.getDefaultMessageSink().add("Finished recording " + this.node.getDestinationName() + " into " + this.messageStore.getId());
            this.hermes.close();
        }
    }
}

