/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.transferable;

import hermes.browser.components.ContextTree;
import hermes.browser.transferable.HermesAdministeredObjectTransferable;
import hermes.browser.transferable.HermesConfigGroup;
import hermes.browser.transferable.JMSAdministeredObjectTransferable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.apache.log4j.Category;

public class ContextTreeTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;
    private static final Category cat = Category.getInstance(ContextTreeTransferHandler.class);
    private ContextTree contextTree;

    public ContextTreeTransferHandler(ContextTree contextTree) {
        this.contextTree = contextTree;
    }

    protected Transferable createTransferable(JComponent c) {
        return new JMSAdministeredObjectTransferable(new HermesConfigGroup(null, this.contextTree.getSelectedDestinations(), this.contextTree.getSelectedConnectionFactories()));
    }

    public void exportAsDrag(JComponent comp, InputEvent e, int action) {
        super.exportAsDrag(comp, e, action);
    }

    public int getSourceActions(JComponent c) {
        if (c instanceof ContextTree) {
            ContextTree contextTree = (ContextTree)c;
            if (contextTree.getSelectedDestinations().size() > 0) {
                return 3;
            }
            if (contextTree.getSelectedConnectionFactories().size() > 0) {
                return 3;
            }
        }
        return 0;
    }

    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        boolean rval = comp instanceof ContextTree;
        if (rval) {
            ContextTree tree = (ContextTree)comp;
            for (int i = 0; i < transferFlavors.length; ++i) {
                if (!transferFlavors[i].equals(HermesAdministeredObjectTransferable.FLAVOR)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean importData(JComponent comp, Transferable t) {
        if (comp instanceof ContextTree) {
            ContextTree contextTree = (ContextTree)comp;
            return contextTree.doImport(t);
        }
        return false;
    }

    protected void exportDone(JComponent source, Transferable data, int action) {
    }
}

