/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.transferable;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Category;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagesTransferable
implements Transferable {
    private static final Category cat = Category.getInstance(MessagesTransferable.class);
    private static DataFlavor[] flavors;
    public static final DataFlavor VM_FLAVOR;
    public static final DataFlavor BYTE_FLAVOR;
    private Collection<Object> messages;

    public MessagesTransferable(Collection<Object> messages) {
        this.messages = messages;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor arg0) {
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(arg0)) continue;
            return true;
        }
        return false;
    }

    public byte[] getBytes(Object o) {
        return o.toString().getBytes();
    }

    @Override
    public Object getTransferData(DataFlavor flavour) throws UnsupportedFlavorException, IOException {
        if (flavour.equals(DataFlavor.stringFlavor) || flavour.getRepresentationClass().equals(String.class)) {
            StringBuffer rval = new StringBuffer();
            for (Object o : this.messages) {
                rval.append(o.toString()).append("\n");
            }
            return rval.toString();
        }
        if (flavour.isMimeTypeEqual(BYTE_FLAVOR)) {
            ArrayList<byte[]> rval = new ArrayList<byte[]>();
            for (Object o : this.messages) {
                rval.add(this.getBytes(o));
            }
            return rval;
        }
        if (flavour.isMimeTypeEqual(VM_FLAVOR)) {
            return this.messages;
        }
        throw new UnsupportedFlavorException(flavour);
    }

    static {
        VM_FLAVOR = new DataFlavor(MessagesTransferable.class, "Messages");
        BYTE_FLAVOR = new DataFlavor(Collection.class, "Byte Messages");
        try {
            flavors = new DataFlavor[]{DataFlavor.stringFlavor, VM_FLAVOR, BYTE_FLAVOR};
        }
        catch (Exception ex) {
            cat.error((Object)("unable to initialise message drag and drop:" + ex.getMessage()), (Throwable)ex);
        }
    }
}

