/*
 * Decompiled with CFR 0.152.
 */
package hermes.impl;

import hermes.Domain;
import hermes.HermesAdminFactory;
import hermes.HermesException;
import hermes.JNDIConnectionFactory;
import hermes.browser.HermesBrowser;
import hermes.config.DestinationConfig;
import hermes.config.FactoryConfig;
import hermes.config.ProviderConfig;
import hermes.config.ProviderExtConfig;
import hermes.ext.ExtensionFinder;
import hermes.ext.ExtensionFinderImpl;
import hermes.impl.ClassLoaderManager;
import hermes.impl.ConnectionFactoryManager;
import hermes.impl.DestinationConfigKeyWrapper;
import hermes.impl.JMSManagerImpl;
import hermes.impl.LoaderSupport;
import hermes.util.JMSUtils;
import hermes.util.ReflectUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;

public class ConnectionFactoryManagerImpl
extends JMSManagerImpl
implements ConnectionFactoryManager {
    private static final Category cat = Category.getInstance(ConnectionFactoryManagerImpl.class);
    private static final Logger traceLogger = Logger.getLogger((String)"javax.jms.trace");
    private static Class[] interfaces = new Class[]{ConnectionFactory.class, QueueConnectionFactory.class, TopicConnectionFactory.class};
    private ExtensionFinder extensionFinder;
    private ConnectionFactory connectionFactory;
    private ConnectionFactory proxyConnectionFactory;
    private String id;
    private String shortString;
    private HermesAdminFactory extension = null;
    private Map<DestinationConfigKeyWrapper, DestinationConfig> destinationConfigs = new HashMap<DestinationConfigKeyWrapper, DestinationConfig>();
    private List<DestinationConfig> destinationConfigsAsList = new ArrayList<DestinationConfig>();
    private boolean trace = false;
    private FactoryConfig factoryConfig;
    private ClassLoaderManager classLoaderManager;

    public ConnectionFactoryManagerImpl(ClassLoaderManager classLoaderManager, FactoryConfig factoryConfig) throws InstantiationException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException {
        this.factoryConfig = factoryConfig;
        this.classLoaderManager = classLoaderManager;
        this.extensionFinder = new ExtensionFinderImpl(classLoaderManager);
        this.setProvider(factoryConfig.getProvider());
    }

    public void close() throws JMSException {
    }

    public void addDestinationConfig(DestinationConfig destConfig) {
        DestinationConfigKeyWrapper key = new DestinationConfigKeyWrapper(destConfig);
        if (this.destinationConfigs.containsKey(key)) {
            DestinationConfig old = this.destinationConfigs.remove(key);
            this.destinationConfigsAsList.remove(old);
            cat.debug((Object)("removed duplicate reference, reference domain=" + Domain.getDomain(destConfig.getDomain()).toString()));
        }
        this.destinationConfigs.put(key, destConfig);
        this.destinationConfigsAsList.add(destConfig);
    }

    public Context createContext() throws NamingException, JMSException {
        if (this.connectionFactory instanceof JNDIConnectionFactory) {
            JNDIConnectionFactory jndiCF = (JNDIConnectionFactory)this.connectionFactory;
            return jndiCF.createContext();
        }
        return null;
    }

    public void removeDestinationConfig(DestinationConfig destConfig) {
        DestinationConfigKeyWrapper key = new DestinationConfigKeyWrapper(destConfig);
        this.destinationConfigs.remove(key);
        this.destinationConfigsAsList.remove(destConfig);
    }

    public void connect() throws JMSException {
    }

    public String getConnectionFactoryType() {
        return null;
    }

    public ConnectionFactory getConnectionFactory() throws JMSException {
        if (this.trace) {
            return this.proxyConnectionFactory;
        }
        return this.connectionFactory;
    }

    public DestinationConfig getDestinationConfig(String id, Domain domain) {
        DestinationConfigKeyWrapper key = new DestinationConfigKeyWrapper(id, domain);
        DestinationConfig rval = this.destinationConfigs.get(key);
        if (rval == null) {
            rval = HermesBrowser.getConfigDAO().createDestinationConfig();
            rval.setName(id);
            rval.setDomain(domain.getId());
            cat.info((Object)("cannot find name=" + id + ", domain=" + domain + " dynamically creating a destination..."));
        }
        return rval;
    }

    public DestinationConfig getDestinationConfig(Destination d) throws JMSException {
        return this.getDestinationConfig(JMSUtils.getDestinationName(d), Domain.getDomain(d));
    }

    public Collection getDestinationConfigs() {
        return this.destinationConfigsAsList;
    }

    public Object getObject() throws JMSException {
        return this.getConnectionFactory();
    }

    public String toString() {
        try {
            return "connectionFactory class=" + this.connectionFactory.getClass().getName() + ", properties=" + BeanUtils.describe((Object)this.connectionFactory);
        }
        catch (Throwable e) {
            return e.getMessage();
        }
    }

    public void setProvider(ProviderConfig pConfig) throws InstantiationException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException {
        ClassLoader classLoader = this.classLoaderManager.getClassLoader(this.factoryConfig.getClasspathId());
        this.connectionFactory = ReflectUtils.createConnectionFactory(classLoader.loadClass(pConfig.getClassName()));
        LoaderSupport.populateBean(this.connectionFactory, pConfig.getProperties());
        this.setConnectionFactory(this.connectionFactory);
    }

    private void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public HermesAdminFactory getExtension(ProviderExtConfig extConfig) throws HermesException {
        if (this.extension == null) {
            try {
                this.extension = this.extensionFinder.createExtension(this.factoryConfig.getClasspathId(), extConfig, this.connectionFactory);
                return this.extension;
            }
            catch (Exception e) {
                throw new HermesException(e);
            }
        }
        return this.extension;
    }

    public ExtensionFinder getExtensionFinder() {
        return this.extensionFinder;
    }

    public void setExtensionFinder(ExtensionFinder extensionFinder) {
        this.extensionFinder = extensionFinder;
    }
}

