/*
 * Decompiled with CFR 0.152.
 */
package hermes.impl;

import hermes.NullConnectionFactory;
import hermes.browser.HermesBrowser;
import hermes.config.ClasspathGroupConfig;
import hermes.config.ProviderExtConfig;
import hermes.impl.ClassLoaderManager;
import hermes.impl.LoaderSupport;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;

public class SimpleClassLoaderManager
implements ClassLoaderManager {
    private static final Logger log = Logger.getLogger(SimpleClassLoaderManager.class);
    public static final String DEFAULT_LOADER = "Default";
    public static final String SYSTEM_LOADER = "System";
    private final Collection emptySet = new HashSet();
    private final Map loaderById = new TreeMap();
    private final Map configById = new TreeMap();
    private final Map factoriesById = new TreeMap();
    private final Map loaderByHermes = new TreeMap();

    public SimpleClassLoaderManager(List classPathGroups) throws IOException {
        for (ClasspathGroupConfig config : classPathGroups) {
            this.add(config);
        }
        System.setSecurityManager(null);
    }

    public void add(ClasspathGroupConfig config) throws IOException {
        log.debug((Object)("adding new ClasspathGroupConfig " + config.getId()));
        this.configById.put(config.getId(), config);
        this.factoriesById.put(config.getId(), LoaderSupport.lookForFactories(config.getLibrary(), this.getClass().getClassLoader()));
    }

    private ClassLoader createClassLoader(String id) throws IOException, JAXBException {
        ProviderExtConfig extConfig = HermesBrowser.getConfigDAO().createDefaultProviderExtConfig(NullConnectionFactory.class.getName());
        return this.createClassLoader(id, extConfig);
    }

    public ClassLoader createClassLoader(String id, ProviderExtConfig extConfig) throws IOException {
        if (id.equals(SYSTEM_LOADER)) {
            return this.getDefaultClassLoader();
        }
        if (this.loaderById.containsKey(id)) {
            log.debug((Object)("createClassLoader id=" + id + " using cached"));
            return (ClassLoader)this.loaderById.get(id);
        }
        log.debug((Object)("createClassLoader id=" + id + " extConfig=" + extConfig.getClassName()));
        ClasspathGroupConfig config = (ClasspathGroupConfig)this.configById.get(id);
        ClassLoader classLoader = null;
        if (config == null) {
            throw new IOException("No such loader: " + id);
        }
        URL[] urls = HermesBrowser.getConfigDAO().getAdminFactoryURLs();
        classLoader = urls != null ? LoaderSupport.createClassLoader(config.getLibrary(), urls, this.getClass().getClassLoader()) : LoaderSupport.createClassLoader(config.getLibrary(), this.getClass().getClassLoader());
        this.loaderById.put(id, classLoader);
        return classLoader;
    }

    public ClassLoader getClassLoader(String id) {
        if (this.loaderById.containsKey(id)) {
            log.debug((Object)("getting existing classLoader for " + id));
            return (ClassLoader)this.loaderById.get(id);
        }
        try {
            log.debug((Object)("creating new classLoader for  " + id));
            return this.createClassLoader(id);
        }
        catch (Exception exception) {
            log.warn((Object)("no ClassLoader " + id + " found, returning the default loader"));
            return this.getDefaultClassLoader();
        }
    }

    public ClassLoader getDefaultClassLoader() {
        if (this.loaderById.containsKey(DEFAULT_LOADER)) {
            return (ClassLoader)this.loaderById.get(DEFAULT_LOADER);
        }
        return this.getClass().getClassLoader();
    }

    public Collection getIds() {
        return this.configById.keySet();
    }

    public ClassLoader getClassLoaderByHermes(String hermesId) {
        return (ClassLoader)this.loaderByHermes.get(hermesId);
    }

    public void putClassLoaderByHermes(String hermesId, ClassLoader classLoader) {
        this.loaderByHermes.put(hermesId, classLoader);
    }

    public Collection getFactories(String id) {
        if (this.factoriesById.containsKey(id)) {
            Collection rval = (Collection)this.factoriesById.get(id);
            if (rval == null) {
                return this.emptySet;
            }
            return rval;
        }
        return null;
    }
}

