/*
 * Decompiled with CFR 0.152.
 */
package hermes.renderers;

import com.jidesoft.grid.SortableTable;
import hermes.browser.ConfigDialogProxy;
import hermes.renderers.AbstractMessageRenderer;
import hermes.swing.SwingUtils;
import hermes.util.JMSUtils;
import java.util.Date;
import java.util.Enumeration;
import javax.jms.Message;
import javax.swing.JComponent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class DefaultMessageHeaderRenderer
extends AbstractMessageRenderer {
    private static final Logger log = Logger.getLogger(DefaultMessageHeaderRenderer.class);

    public JComponent render(Message m) {
        SortableTable table = new SortableTable();
        DefaultTableModel tableModel = new DefaultTableModel(){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        tableModel.addColumn("Property");
        tableModel.addColumn("Value");
        try {
            tableModel.addRow(new Object[]{"JMSMessageID", m.getJMSMessageID()});
        }
        catch (Exception ex) {
            log.error((Object)("no JMSMessageID in message: " + ex.getMessage()));
        }
        try {
            tableModel.addRow(new Object[]{"JMSDestination", JMSUtils.getDestinationName(m.getJMSDestination())});
        }
        catch (Exception ex) {
            log.error((Object)("no JMSDestination in message: " + ex.getMessage()));
        }
        try {
            tableModel.addRow(new Object[]{"JMSTimestamp", new Date(m.getJMSTimestamp())});
        }
        catch (Exception ex) {
            tableModel.addRow(new Object[]{"JMSTimestamp", new Date()});
            log.error((Object)("no JMSTimestamp in message: " + ex.getMessage()));
        }
        try {
            tableModel.addRow(new Object[]{"JMSType", m.getJMSType()});
        }
        catch (Exception ex) {
            log.error((Object)("no JMSType in message: " + ex.getMessage()));
        }
        try {
            tableModel.addRow(new Object[]{"JMSReplyTo", JMSUtils.getDestinationName(m.getJMSReplyTo())});
        }
        catch (Exception ex) {
            log.error((Object)("no JMSReplyTo in message: " + ex.getMessage()));
        }
        try {
            tableModel.addRow(new Object[]{"JMSCorrelationID", m.getJMSCorrelationID()});
        }
        catch (Exception ex) {
            log.error((Object)("no JMSCorrelationID in message: " + ex.getMessage()));
        }
        try {
            tableModel.addRow(new Object[]{"JMSExpiration", new Long(m.getJMSExpiration())});
        }
        catch (Exception ex) {
            log.error((Object)("no JMSExpiration in message: " + ex.getMessage()));
        }
        try {
            tableModel.addRow(new Object[]{"JMSPriority", new Long(m.getJMSPriority())});
        }
        catch (Exception ex) {
            log.error((Object)("no JMSPriority in message: " + ex.getMessage()));
        }
        try {
            if (m.getPropertyNames() != null) {
                Enumeration iter = m.getPropertyNames();
                while (iter.hasMoreElements()) {
                    try {
                        String propertyName = (String)iter.nextElement();
                        Object propertyValue = m.getObjectProperty(propertyName);
                        Object[] row = new Object[]{propertyName, propertyValue};
                        tableModel.addRow(row);
                    }
                    catch (RuntimeException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        catch (Throwable e) {
            Object[] row = new Object[]{"Error", e.getClass().getName() + ": " + e.getMessage()};
            tableModel.addRow(row);
            log.error((Object)e.getMessage(), e);
        }
        table.setModel((TableModel)tableModel);
        return SwingUtils.createJScrollPane((JComponent)table);
    }

    public JComponent getConfigPanel(ConfigDialogProxy dialogProxy) throws Exception {
        return null;
    }

    public boolean canRender(Message message) {
        return true;
    }

    public String getDisplayName() {
        return "Header";
    }
}

