/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing;

import hermes.swing.SwingRunner;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class TimedSwingRunner {
    private static Timer timer = new Timer();
    private long timeout;
    private Map<Object, Runnable> runnables = new HashMap<Object, Runnable>();
    private boolean stopped = false;

    public TimedSwingRunner(long timeout) {
        this.timeout = timeout;
        TimerTask task = new TimerTask(){

            public void run() {
                TimedSwingRunner.this.drain();
            }
        };
        timer.schedule(task, timeout);
    }

    public synchronized void invokeLater(Object context, Runnable runnable) {
        this.runnables.put(context, runnable);
    }

    public void stop() {
        this.stopped = true;
    }

    private synchronized void drain() {
        for (Runnable runnable : this.runnables.values()) {
            if (runnable == null) continue;
            SwingRunner.invokeLater(runnable);
        }
        this.runnables.clear();
        if (!this.stopped) {
            TimerTask task = new TimerTask(){

                public void run() {
                    TimedSwingRunner.this.drain();
                }
            };
            timer.schedule(task, this.timeout);
        }
    }
}

