/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import hermes.Hermes;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.actions.AbstractDocumentComponent;
import hermes.browser.actions.AbstractFIXBrowserDocumentComponent;
import hermes.browser.actions.BrowserAction;
import hermes.fix.FIXMessage;
import hermes.fix.FIXUtils;
import hermes.impl.DefaultXMLHelper;
import hermes.impl.XMLHelper;
import hermes.swing.actions.BrowseActionListenerAdapter;
import hermes.util.TextUtils;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class CopyMessagesToClipboardAction
extends BrowseActionListenerAdapter {
    private static final Logger log = Logger.getLogger(CopyMessagesToClipboardAction.class);
    private XMLHelper xmlHelper = new DefaultXMLHelper();

    public CopyMessagesToClipboardAction() {
        this.putValue("Name", "Copy");
        this.putValue("ShortDescription", "Copy selected messages to clipboard");
        this.putValue("SmallIcon", IconCache.getIcon("copy"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65485, 0, false));
        this.setEnabled(false);
        this.addDocumentType(AbstractFIXBrowserDocumentComponent.class);
    }

    public void actionPerformed(ActionEvent arg0) {
        StringSelection t;
        Clipboard systemcClipboard;
        AbstractDocumentComponent browserAction;
        if (HermesBrowser.getBrowser().getDocumentPane().getActiveDocument() instanceof BrowserAction) {
            try {
                browserAction = (BrowserAction)HermesBrowser.getBrowser().getDocumentPane().getActiveDocument();
                Collection<Message> messages = ((BrowserAction)browserAction).getSelectedMessages();
                systemcClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                t = new StringSelection(this.xmlHelper.toXML(messages));
                systemcClipboard.setContents(t, null);
                Hermes.ui.getDefaultMessageSink().add(messages.size() + " message" + TextUtils.plural(messages.size()) + " copied to clipboard");
            }
            catch (HeadlessException e) {
                log.error((Object)("doCopy(): " + e.getMessage()), (Throwable)e);
            }
            catch (JMSException e) {
                HermesBrowser.getBrowser().showErrorDialog("During copy: ", e);
            }
        }
        if (HermesBrowser.getBrowser().getDocumentPane().getActiveDocument() instanceof AbstractFIXBrowserDocumentComponent) {
            browserAction = (AbstractFIXBrowserDocumentComponent)HermesBrowser.getBrowser().getDocumentPane().getActiveDocument();
            StringBuffer b = new StringBuffer();
            for (Object o : ((AbstractFIXBrowserDocumentComponent)browserAction).getSelectedMessages()) {
                FIXMessage message = (FIXMessage)o;
                b.append(FIXUtils.prettyPrint(message));
                b.append("\n");
            }
            systemcClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            t = new StringSelection(b.toString());
            systemcClipboard.setContents(t, null);
            Hermes.ui.getDefaultMessageSink().add(((AbstractFIXBrowserDocumentComponent)browserAction).getSelectedMessages().size() + " message" + TextUtils.plural(((AbstractFIXBrowserDocumentComponent)browserAction).getSelectedMessages().size()) + " copied to clipboard");
        }
    }
}

