/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import hermes.Hermes;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.actions.FIXFileBrowserAction;
import hermes.swing.actions.ActionSupport;
import hermes.swing.actions.DirectoryCache;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;

public class OpenFIXFileAction
extends ActionSupport {
    public OpenFIXFileAction() {
        this.putValue("Name", "Open FIX File...");
        this.putValue("ShortDescription", "Open a file containing FIX messages");
        this.putValue("SmallIcon", IconCache.getIcon("hermes.file.fix"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.setEnabled(true);
    }

    public void actionPerformed(ActionEvent arg0) {
        try {
            JFileChooser chooser = null;
            chooser = DirectoryCache.lastUploadDirectory == null ? new JFileChooser(System.getProperty("user.dir")) : new JFileChooser(DirectoryCache.lastUploadDirectory);
            if (chooser.showDialog((Component)((Object)HermesBrowser.getBrowser()), "Open") == 0) {
                DirectoryCache.lastUploadDirectory = chooser.getSelectedFile().getParentFile();
                int maxCachedMessages = HermesBrowser.getBrowser().getMaxMessagesInBrowserPane();
                new FIXFileBrowserAction(chooser.getSelectedFile(), maxCachedMessages).start();
            } else {
                Hermes.ui.getDefaultMessageSink().add("File open cancelled");
            }
        }
        catch (Exception ex) {
            HermesBrowser.getBrowser().showErrorDialog("Unable to open: ", ex);
        }
    }
}

