/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import hermes.Hermes;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.actions.FIXFileBrowserAction;
import hermes.swing.actions.ActionSupport;
import hermes.util.TextUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.JOptionPane;

public class OpenFIXURLAction
extends ActionSupport {
    private String previousURL;

    public OpenFIXURLAction() {
        this.putValue("Name", "Open FIX URL...");
        this.putValue("ShortDescription", "Open a URL referencing FIX messages");
        this.putValue("SmallIcon", IconCache.getIcon("hermes.file.fix"));
        this.setEnabled(true);
    }

    public void actionPerformed(ActionEvent arg0) {
        try {
            String url;
            this.previousURL = url = JOptionPane.showInputDialog((Component)((Object)HermesBrowser.getBrowser()), "URL", this.previousURL);
            if (!TextUtils.isEmpty(url)) {
                int maxCachedMessages = HermesBrowser.getBrowser().getMaxMessagesInBrowserPane();
                new FIXFileBrowserAction(new URL(url), maxCachedMessages).start();
            } else {
                Hermes.ui.getDefaultMessageSink().add("URL open cancelled");
            }
        }
        catch (Exception ex) {
            HermesBrowser.getBrowser().showErrorDialog("Unable to open: ", ex);
        }
    }
}

