/*
 * Decompiled with CFR 0.152.
 */
package hermes.util;

import hermes.util.IoUtils;
import hermes.util.TextUtils;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class XmlUtils {
    private static final Logger log = Logger.getLogger(XmlUtils.class);

    public static String prettyPrintXml(byte[] bytes) {
        String r = new String(bytes);
        String s = null;
        try {
            s = XmlUtils.prettyPrintXml(r);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            s = TextUtils.printException(e);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String prettyPrintXml(String s) throws IOException, ParserConfigurationException, SAXException {
        block2: {
            if (!XmlUtils.isXML(s)) break block2;
            StringReader reader = null;
            InputSource source = null;
            String ret = null;
            try {
                reader = new StringReader(s);
                source = new InputSource(reader);
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(source);
                ret = XmlUtils.prettyPrintXml(doc);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(reader);
                throw throwable;
            }
            IoUtils.closeQuietly(reader);
            return ret;
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String prettyPrintXml(Document doc) throws IOException {
        StringWriter writer = null;
        String ret = null;
        try {
            writer = new StringWriter();
            OutputFormat format = new OutputFormat(doc);
            format.setLineWidth(80);
            format.setIndenting(true);
            format.setIndent(2);
            XMLSerializer serializer = new XMLSerializer((Writer)writer, format);
            serializer.serialize(doc);
            ret = writer.toString();
        }
        finally {
            IoUtils.closeQuietly(writer);
        }
        return ret;
    }

    public static boolean isXML(String s) {
        return s != null && s.startsWith("<?xml");
    }
}

