/*
 * Decompiled with CFR 0.152.
 */
package org.uddi4j.response;

import java.util.Vector;
import org.uddi4j.UDDIElement;
import org.uddi4j.UDDIException;
import org.uddi4j.datatype.Description;
import org.uddi4j.datatype.Name;
import org.uddi4j.response.ServiceInfos;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BusinessInfo
extends UDDIElement {
    public static final String UDDI_TAG = "businessInfo";
    protected Element base = null;
    String businessKey = null;
    Name name = null;
    ServiceInfos serviceInfos = null;
    Vector description = new Vector();

    public BusinessInfo() {
    }

    public BusinessInfo(String businessKey, String name, ServiceInfos serviceInfos) {
        this.businessKey = businessKey;
        this.name = new Name(name);
        this.serviceInfos = serviceInfos;
    }

    public BusinessInfo(Element base) throws UDDIException {
        super(base);
        this.businessKey = base.getAttribute("businessKey");
        NodeList nl = null;
        nl = this.getChildElementsByTagName(base, "name");
        if (nl.getLength() > 0) {
            this.name = new Name((Element)nl.item(0));
        }
        if ((nl = this.getChildElementsByTagName(base, "serviceInfos")).getLength() > 0) {
            this.serviceInfos = new ServiceInfos((Element)nl.item(0));
        }
        nl = this.getChildElementsByTagName(base, "description");
        int i = 0;
        while (i < nl.getLength()) {
            this.description.addElement(new Description((Element)nl.item(i)));
            ++i;
        }
    }

    public void setBusinessKey(String s) {
        this.businessKey = s;
    }

    public void setName(Name s) {
        this.name = s;
    }

    public void setName(String s) {
        this.name = new Name();
        this.name.setText(s);
    }

    public void setServiceInfos(ServiceInfos s) {
        this.serviceInfos = s;
    }

    public void setDescriptionVector(Vector s) {
        this.description = s;
    }

    public void setDefaultDescriptionString(String s) {
        if (this.description.size() > 0) {
            this.description.setElementAt(new Description(s), 0);
        } else {
            this.description.addElement(new Description(s));
        }
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public Name getName() {
        return this.name;
    }

    public String getNameString() {
        return this.name.getText();
    }

    public ServiceInfos getServiceInfos() {
        return this.serviceInfos;
    }

    public Vector getDescriptionVector() {
        return this.description;
    }

    public String getDefaultDescriptionString() {
        if (this.description.size() > 0) {
            Description t = (Description)this.description.elementAt(0);
            return t.getText();
        }
        return null;
    }

    public void saveToXML(Element parent) {
        this.base = parent.getOwnerDocument().createElement(UDDI_TAG);
        if (this.businessKey != null) {
            this.base.setAttribute("businessKey", this.businessKey);
        }
        if (this.name != null) {
            this.name.saveToXML(this.base);
        }
        if (this.description != null) {
            int i = 0;
            while (i < this.description.size()) {
                ((Description)this.description.elementAt(i)).saveToXML(this.base);
                ++i;
            }
        }
        if (this.serviceInfos != null) {
            this.serviceInfos.saveToXML(this.base);
        }
        parent.appendChild(this.base);
    }
}

