/*
 * Decompiled with CFR 0.152.
 */
package org.uddi4j.response;

import java.util.Vector;
import org.uddi4j.UDDIElement;
import org.uddi4j.UDDIException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DispositionReport
extends UDDIElement {
    public static String UDDI_TAG = "dispositionReport";
    String genericAttrib = null;
    String operatorAttrib = null;
    Vector errno = new Vector();
    Vector errCode = new Vector();
    Vector errInfoText = new Vector();
    Vector keyType = new Vector();
    public static final String E_assertionNotFound = "E_assertionNotFound";
    public static final String E_authTokenExpired = "E_authTokenExpired";
    public static final String E_authTokenRequired = "E_authTokenRequired";
    public static final String E_accountLimitExceeded = "E_accountLimitExceeded";
    public static final String E_busy = "E_busy";
    public static final String E_categorizationNotAllowed = "E_categorizationNotAllowed";
    public static final String E_fatalError = "E_fatalError";
    public static final String E_invalidKeyPassed = "E_invalidKeyPassed";
    public static final String E_invalidProjection = "E_invalidProjection";
    public static final String E_invalidCategory = "E_invalidCategory";
    public static final String E_invalidCompletionStatus = "E_invalidCompletionStatus";
    public static final String E_invalidURLPassed = "E_invalidURLPassed";
    public static final String E_invalidValue = "E_invalidValue";
    public static final String E_keyRetired = "E_keyRetired";
    public static final String E_languageError = "E_languageError";
    public static final String E_messageTooLarge = "E_messageTooLarge";
    public static final String E_nameTooLong = "E_nameTooLong";
    public static final String E_operatorMismatch = "E_operatorMismatch";
    public static final String E_publisherCancelled = "E_publisherCancelled";
    public static final String E_requestDenied = "E_requestDenied";
    public static final String E_requestTimeout = "E_requestTimeout";
    public static final String E_secretUnknown = "E_secretUnknown";
    public static final String E_success = "E_success";
    public static final String E_tooManyOptions = "E_tooManyOptions";
    public static final String E_transferAborted = "E_transferAborted";
    public static final String E_unrecognizedVersion = "E_unrecognizedVersion";
    public static final String E_unknownUser = "E_unknownUser";
    public static final String E_unsupported = "E_unsupported";
    public static final String E_unvalidatable = "E_unvalidatable";
    public static final String E_userMismatch = "E_userMismatch";
    public static final String E_valueNotAllowed = "E_valueNotAllowed";

    public DispositionReport() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DispositionReport(Element el) throws UDDIException {
        NodeList nl;
        boolean fault = false;
        UDDIException exception = null;
        if (UDDIException.isValidElement(el)) {
            fault = true;
            exception = new UDDIException(el, true);
            nl = exception.getDetailElement().getElementsByTagName(UDDI_TAG);
            if (nl.getLength() <= 0) throw exception;
            this.base = (Element)nl.item(0);
        } else {
            this.base = el;
        }
        if (this.isValidElement(this.base)) {
            this.genericAttrib = el.getAttribute("generic");
            this.operatorAttrib = el.getAttribute("operator");
            nl = el.getElementsByTagName("result");
            int i = 0;
            while (i < nl.getLength()) {
                Element tmp = (Element)nl.item(i);
                String errnoString = tmp.getAttribute("errno");
                Integer errnoInt = new Integer(errnoString);
                this.errno.add(errnoInt);
                nl = tmp.getElementsByTagName("errInfo");
                if (nl.getLength() > i) {
                    tmp = (Element)nl.item(i);
                    this.errCode.add(tmp.getAttribute("errCode"));
                    this.keyType.add(tmp.getAttribute("keyType"));
                    this.errInfoText.add(this.getText(tmp));
                }
                ++i;
            }
        }
        if (!fault) return;
        throw exception;
    }

    public String getGeneric() {
        return this.genericAttrib;
    }

    public String getOperator() {
        return this.operatorAttrib;
    }

    public boolean success() {
        boolean success = true;
        int i = 0;
        while (i < this.errno.size()) {
            int errnoInt = (Integer)this.errno.elementAt(i);
            success = success && errnoInt == 0;
            ++i;
        }
        return success;
    }

    public int getErrno() {
        return this.getErrno(0);
    }

    public int getErrno(int index) {
        return (Integer)this.errno.elementAt(index);
    }

    public String getErrCode() {
        return this.getErrCode(0);
    }

    public String getErrCode(int index) {
        return (String)this.errCode.elementAt(index);
    }

    public String getErrInfoText() {
        return this.getErrInfoText(0);
    }

    public String getErrInfoText(int index) {
        return (String)this.errInfoText.elementAt(index);
    }

    public String getKeyType() {
        return this.getKeyType(0);
    }

    public String getKeyType(int index) {
        return (String)this.keyType.elementAt(index);
    }

    public int getNumResults() {
        return this.errno.size();
    }

    public void setGeneric(String gen) {
        this.genericAttrib = gen;
    }

    public void setOperator(String oper) {
        this.operatorAttrib = oper;
    }

    public void setErrno(int errno) {
        this.setErrno(0, errno);
    }

    public void setErrno(int errno, int index) {
        if (index > this.errno.size()) {
            this.errno.setSize(index);
        }
        this.errno.setElementAt(new Integer(errno), index);
    }

    public void setErrCode(String errCode) {
        this.setErrCode(errCode, 0);
    }

    public void setErrCode(String errCode, int index) {
        if (index > this.errCode.size()) {
            this.errCode.setSize(index);
        }
        this.errCode.setElementAt(errCode, index);
    }

    public void setErrInfoText(String errInfoText) {
        this.setErrInfoText(errInfoText, 0);
    }

    public void setErrInfoText(String errInfoText, int index) {
        if (index > this.errInfoText.size()) {
            this.errInfoText.setSize(index);
        }
        this.errInfoText.setElementAt(errInfoText, index);
    }

    public void setKeyType(String keyType) {
        this.setKeyType(keyType, 0);
    }

    public void setKeyType(String keyType, int index) {
        if (index > this.keyType.size()) {
            this.keyType.setSize(index);
        }
        this.keyType.setElementAt(keyType, index);
    }

    public boolean isValidElement(Element el) {
        return el.getNodeName().equals(UDDI_TAG);
    }

    public void saveToXML(Element parent) {
        this.base = parent.getOwnerDocument().createElement(UDDI_TAG);
        if (this.genericAttrib != null) {
            this.base.setAttribute("generic", this.genericAttrib);
        }
        this.base.setAttribute("xmlns", UDDIElement.XMLNS);
        if (this.operatorAttrib != null) {
            this.base.setAttribute("operator", this.operatorAttrib);
        }
        int i = 0;
        while (i < this.errno.size()) {
            Element result = parent.getOwnerDocument().createElement("result");
            result.setAttribute("errno", ((Integer)this.errno.elementAt(i)).toString());
            Element errInfo = parent.getOwnerDocument().createElement("errInfo");
            errInfo.setAttribute("errCode", (String)this.errCode.elementAt(i));
            if (this.keyType.elementAt(i) != null && !"".equals((String)this.keyType.elementAt(i))) {
                errInfo.setAttribute("keyType", (String)this.keyType.elementAt(i));
            }
            errInfo.setNodeValue((String)this.errInfoText.elementAt(i));
            result.appendChild(errInfo);
            this.base.appendChild(result);
            ++i;
        }
        parent.appendChild(this.base);
    }
}

