/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import java.math.BigInteger;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.utils.RFC2253Parser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public final class DOMX509IssuerSerial {
    private final Element element;
    private final String issuer;
    private final BigInteger serialNumber;

    public DOMX509IssuerSerial(Element issuerSerialElement) {
        this.element = issuerSerialElement;
        Element issuerNameElement = WSSecurityUtil.getDirectChildElement(this.element, "X509IssuerName", "http://www.w3.org/2000/09/xmldsig#");
        this.issuer = this.getChildText(issuerNameElement);
        Element serialNumberElement = WSSecurityUtil.getDirectChildElement(this.element, "X509SerialNumber", "http://www.w3.org/2000/09/xmldsig#");
        String serialNumberStr = this.getChildText(serialNumberElement);
        this.serialNumber = new BigInteger(serialNumberStr);
    }

    public DOMX509IssuerSerial(Document doc, String issuer, BigInteger serialNumber) {
        if (issuer == null) {
            throw new NullPointerException("The issuerName cannot be null");
        }
        if (serialNumber == null) {
            throw new NullPointerException("The serialNumber cannot be null");
        }
        this.issuer = RFC2253Parser.normalize((String)issuer);
        this.serialNumber = serialNumber;
        this.element = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:X509IssuerSerial");
        Element issuerNameElement = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:X509IssuerName");
        issuerNameElement.appendChild(doc.createTextNode(this.issuer));
        this.element.appendChild(issuerNameElement);
        Element serialNumberElement = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:X509SerialNumber");
        serialNumberElement.appendChild(doc.createTextNode(serialNumber.toString()));
        this.element.appendChild(serialNumberElement);
    }

    public Element getElement() {
        return this.element;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }

    private String getChildText(Node parentNode) {
        StringBuilder buffer = new StringBuilder();
        for (Node node = parentNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (3 != node.getNodeType()) continue;
            buffer.append(((Text)node).getData());
        }
        return buffer.toString();
    }
}

