/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.c14n;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.CanonicalizerSpi;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.AlgorithmAlreadyRegisteredException;
import org.apache.xml.security.utils.IgnoreAllErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Canonicalizer {
    public static final String ENCODING = "UTF8";
    public static final String XPATH_C14N_WITH_COMMENTS_SINGLE_NODE = "(.//. | .//@* | .//namespace::*)";
    public static final String ALGO_ID_C14N_OMIT_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    public static final String ALGO_ID_C14N_WITH_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    public static final String ALGO_ID_C14N_EXCL_OMIT_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String ALGO_ID_C14N_EXCL_WITH_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    public static final String ALGO_ID_C14N11_OMIT_COMMENTS = "http://www.w3.org/2006/12/xml-c14n11";
    public static final String ALGO_ID_C14N11_WITH_COMMENTS = "http://www.w3.org/2006/12/xml-c14n11#WithComments";
    static boolean _alreadyInitialized = false;
    static Map _canonicalizerHash = null;
    protected CanonicalizerSpi canonicalizerSpi = null;

    public static void init() {
        if (!_alreadyInitialized) {
            _canonicalizerHash = new HashMap(10);
            _alreadyInitialized = true;
        }
    }

    private Canonicalizer(String string) throws InvalidCanonicalizerException {
        try {
            Class clazz = Canonicalizer.getImplementingClass(string);
            this.canonicalizerSpi = (CanonicalizerSpi)clazz.newInstance();
            this.canonicalizerSpi.reset = true;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{string};
            throw new InvalidCanonicalizerException("signature.Canonicalizer.UnknownCanonicalizer", objectArray);
        }
    }

    public static final Canonicalizer getInstance(String string) throws InvalidCanonicalizerException {
        Canonicalizer canonicalizer = new Canonicalizer(string);
        return canonicalizer;
    }

    public static void register(String string, String string2) throws AlgorithmAlreadyRegisteredException {
        Class clazz = Canonicalizer.getImplementingClass(string);
        if (clazz != null) {
            Object[] objectArray = new Object[]{string, clazz};
            throw new AlgorithmAlreadyRegisteredException("algorithm.alreadyRegistered", objectArray);
        }
        try {
            _canonicalizerHash.put(string, Class.forName(string2));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("c14n class not found");
        }
    }

    public final String getURI() {
        return this.canonicalizerSpi.engineGetURI();
    }

    public boolean getIncludeComments() {
        return this.canonicalizerSpi.engineGetIncludeComments();
    }

    public byte[] canonicalize(byte[] byArray) throws ParserConfigurationException, IOException, SAXException, CanonicalizationException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputSource inputSource = new InputSource(byteArrayInputStream);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new IgnoreAllErrorHandler());
        Document document = documentBuilder.parse(inputSource);
        byte[] byArray2 = this.canonicalizeSubtree(document);
        return byArray2;
    }

    public byte[] canonicalizeSubtree(Node node) throws CanonicalizationException {
        return this.canonicalizerSpi.engineCanonicalizeSubTree(node);
    }

    public byte[] canonicalizeSubtree(Node node, String string) throws CanonicalizationException {
        return this.canonicalizerSpi.engineCanonicalizeSubTree(node, string);
    }

    public byte[] canonicalizeXPathNodeSet(NodeList nodeList) throws CanonicalizationException {
        return this.canonicalizerSpi.engineCanonicalizeXPathNodeSet(nodeList);
    }

    public byte[] canonicalizeXPathNodeSet(NodeList nodeList, String string) throws CanonicalizationException {
        return this.canonicalizerSpi.engineCanonicalizeXPathNodeSet(nodeList, string);
    }

    public byte[] canonicalizeXPathNodeSet(Set set) throws CanonicalizationException {
        return this.canonicalizerSpi.engineCanonicalizeXPathNodeSet(set);
    }

    public byte[] canonicalizeXPathNodeSet(Set set, String string) throws CanonicalizationException {
        return this.canonicalizerSpi.engineCanonicalizeXPathNodeSet(set, string);
    }

    public void setWriter(OutputStream outputStream) {
        this.canonicalizerSpi.setWriter(outputStream);
    }

    public String getImplementingCanonicalizerClass() {
        return this.canonicalizerSpi.getClass().getName();
    }

    private static Class getImplementingClass(String string) {
        return (Class)_canonicalizerHash.get(string);
    }

    public void notReset() {
        this.canonicalizerSpi.reset = false;
    }
}

