/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter.gradient;

import java.awt.Graphics2D;
import java.awt.Paint;
import javax.swing.JComponent;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.util.Resize;

public abstract class AbstractGradientPainter
extends AbstractPainter {
    private Resize resize = Resize.BOTH;

    public void paintBackground(Graphics2D g, JComponent component) {
        Paint p = this.calculateSizedPaint(component.getWidth(), component.getHeight());
        if (p != null) {
            g.setPaint(p);
            g.fillRect(0, 0, component.getWidth(), component.getHeight());
        }
    }

    protected abstract Paint calculateSizedPaint(int var1, int var2);

    public Resize getResize() {
        return this.resize;
    }

    public void setResize(Resize resize) {
        Resize old = this.getResize();
        boolean rh = this.isResizeHorizontal();
        boolean rv = this.isResizeVertical();
        this.resize = resize == null ? Resize.BOTH : resize;
        this.firePropertyChange("resize", (Object)old, (Object)this.getResize());
        this.firePropertyChange("resizeHorizontal", rh, this.isResizeHorizontal());
        this.firePropertyChange("resizeVertical", rv, this.isResizeVertical());
    }

    protected boolean isResizeHorizontal() {
        Resize r = this.getResize();
        return r == Resize.BOTH || r == Resize.HORIZONTAL;
    }

    protected boolean isResizeVertical() {
        Resize r = this.getResize();
        return r == Resize.BOTH || r == Resize.VERTICAL;
    }
}

