/*
 * Decompiled with CFR 0.152.
 */
package flex.management.runtime.messaging;

import flex.management.BaseControl;
import flex.management.runtime.messaging.DestinationControlMBean;
import flex.management.runtime.messaging.services.ServiceControl;
import flex.messaging.Destination;
import flex.messaging.services.ServiceAdapter;
import java.util.Date;
import javax.management.ObjectName;

public abstract class DestinationControl
extends BaseControl
implements DestinationControlMBean {
    protected Destination destination;
    private ObjectName adapter;

    public DestinationControl(Destination destination, BaseControl parent) {
        super(parent);
        this.destination = destination;
    }

    public String getId() {
        return this.destination.getId();
    }

    public ObjectName getAdapter() {
        return this.adapter;
    }

    public void setAdapter(ObjectName value) {
        this.adapter = value;
    }

    public Boolean isRunning() {
        return this.destination.isStarted();
    }

    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    public void preDeregister() throws Exception {
        ServiceControl parent = (ServiceControl)this.getParentControl();
        parent.removeDestination(this.getObjectName());
        ServiceAdapter child = this.destination.getAdapter();
        if (child.getControl() != null) {
            child.getControl().unregister();
            child.setControl(null);
            child.setManaged(false);
        }
        super.preDeregister();
    }
}

