/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging;

import flex.management.runtime.messaging.MessageBrokerControl;
import flex.messaging.FlexSession;
import flex.messaging.FlexSessionListener;
import flex.messaging.MessageBroker;

public class SessionMetricsTracker
implements FlexSessionListener {
    private int connectionCount;
    private int currentConnectionCountMax;
    private MessageBroker messageBroker;

    public SessionMetricsTracker(MessageBroker messageBroker) {
        this.messageBroker = messageBroker;
    }

    public synchronized void sessionCreated(FlexSession session) {
        session.addSessionDestroyedListener(this);
        ++this.connectionCount;
        if (this.connectionCount > this.currentConnectionCountMax) {
            this.currentConnectionCountMax = this.connectionCount;
        }
        if (this.messageBroker.isManaged()) {
            ((MessageBrokerControl)this.messageBroker.getControl()).setFlexSessionCount(this.connectionCount);
            ((MessageBrokerControl)this.messageBroker.getControl()).setMaxFlexSessionsInCurrentHour(this.currentConnectionCountMax);
        }
    }

    public synchronized void sessionDestroyed(FlexSession session) {
        session.removeSessionDestroyedListener(this);
        --this.connectionCount;
        if (this.messageBroker.isManaged()) {
            ((MessageBrokerControl)this.messageBroker.getControl()).setFlexSessionCount(this.connectionCount);
            ((MessageBrokerControl)this.messageBroker.getControl()).setMaxFlexSessionsInCurrentHour(this.currentConnectionCountMax);
        }
    }

    public synchronized void start() {
        FlexSession.addSessionCreatedListener(this);
    }

    public synchronized void stop() {
        FlexSession.removeSessionCreatedListener(this);
    }
}

