/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.webkit;

import com.teamdev.jxbrowser.webkit.WebBrowser;
import com.teamdev.jxbrowser.webkit.WebBrowserWindow;
import com.teamdev.jxbrowser.webkit.WindowCreator;
import com.teamdev.jxbrowser.webkit.event.BrowserAdapter;
import com.teamdev.jxbrowser.webkit.event.BrowserEvent;
import java.awt.BorderLayout;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class DefaultWindowCreator
implements WindowCreator {
    public WebBrowserWindow createWindow() {
        return new PopupWindow();
    }

    private class PopupWindow
    implements WebBrowserWindow {
        private JFrame popupWindow;
        private JPanel contentPane;

        private PopupWindow() {
        }

        public void createWindow(final WebBrowser webBrowser) {
            this.contentPane = new JPanel(new BorderLayout());
            this.contentPane.add(webBrowser.getComponent(), "Center");
            this.popupWindow = new JFrame();
            this.popupWindow.setContentPane(this.contentPane);
            this.popupWindow.setDefaultCloseOperation(2);
            webBrowser.addBrowserListener(new BrowserAdapter(){

                public void onTitleChange(BrowserEvent browserEvent) {
                    PopupWindow.this.popupWindow.setTitle(browserEvent.getTitle());
                }
            });
            this.popupWindow.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent windowEvent) {
                    webBrowser.dispose();
                }
            });
        }

        public void disposeWindow() {
            this.popupWindow.dispose();
        }

        public void setVisible(boolean bl) {
            this.popupWindow.setVisible(bl);
        }

        public void setBounds(Rectangle rectangle) {
            this.popupWindow.setLocation(rectangle.getLocation());
            this.contentPane.setPreferredSize(rectangle.getSize());
            this.popupWindow.pack();
        }
    }
}

