/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.webkit;

import com.jniwrapper.DoubleFloat;
import com.jniwrapper.Int;
import com.jniwrapper.Int64;
import com.jniwrapper.Pointer;
import com.jniwrapper.ShortInt;
import com.jniwrapper.SingleFloat;
import com.teamdev.jxbrowser.webkit.SafariBrowserFunction;
import com.teamdev.jxbrowser.webkit.cocoa.Id;
import com.teamdev.jxbrowser.webkit.cocoa.nsobject.NSObject;
import com.teamdev.jxbrowser.webkit.cocoa.nsstring.NSString;
import com.teamdev.jxbrowser.webkit.cocoa.nsvalue.NSNumber;
import com.teamdev.jxbrowser.webkit.webkit.WebScriptObject;
import java.util.HashMap;
import java.util.Map;

public class JavaScriptJavaBridge {
    private final Map<String, SafariBrowserFunction> registeredFunctions = new HashMap<String, SafariBrowserFunction>();

    private long callJava(long l, long l2) {
        NSString nSString = new NSString(new Pointer.Void(l));
        String string = nSString.UTF8String().getValue();
        if (this.registeredFunctions.containsKey(string)) {
            WebScriptObject webScriptObject = new WebScriptObject(new Pointer.Void(l2));
            Object[] objectArray = this.toJavaArgs(webScriptObject);
            SafariBrowserFunction safariBrowserFunction = this.registeredFunctions.get(string);
            try {
                Object object = safariBrowserFunction.invoke(objectArray);
                return this.toJavaScript(object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return 0L;
    }

    public void registerFunction(String string, SafariBrowserFunction safariBrowserFunction) {
        this.registeredFunctions.put(string, safariBrowserFunction);
    }

    private Object[] toJavaArgs(WebScriptObject webScriptObject) {
        Id id = webScriptObject.valueForKey("length");
        NSNumber nSNumber = new NSNumber(id);
        int n = (int)nSNumber.intValue().getValue();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < objectArray.length; ++i) {
            Id id2 = webScriptObject.webScriptValueAtIndex(i);
            objectArray[i] = this.toJava(id2);
        }
        return objectArray;
    }

    private Object toJava(Id id) {
        NSObject nSObject = new NSObject(id);
        if (nSObject.isKindOfClass(NSObject.getCClass("NSString")).getValue()) {
            NSString nSString = new NSString(id);
            return nSString.UTF8String().getValue();
        }
        if (nSObject.isKindOfClass(NSObject.getCClass("NSNumber")).getValue()) {
            NSNumber nSNumber = new NSNumber(id);
            String string = nSNumber.objCType().getValue();
            if (string.equals("d")) {
                int n;
                double d = nSNumber.doubleValue().getValue();
                if (d - (double)(n = (int)d) > 0.0) {
                    return d;
                }
                return n;
            }
            if (string.equals("c")) {
                return nSNumber.boolValue().getValue();
            }
        }
        return null;
    }

    private long toJavaScript(Object object) {
        if (object instanceof String) {
            NSString nSString = new NSString((String)object);
            return nSString.getValue();
        }
        if (object instanceof Integer) {
            return NSNumber.static_numberWithInt(new Int((long)((Integer)object).intValue())).getValue();
        }
        if (object instanceof Short) {
            return NSNumber.static_numberWithShort(new ShortInt((long)((Short)object).shortValue())).getValue();
        }
        if (object instanceof Float) {
            return NSNumber.static_numberWithFloat(new SingleFloat((double)((Float)object).floatValue())).getValue();
        }
        if (object instanceof Double) {
            return NSNumber.static_numberWithDouble(new DoubleFloat(((Double)object).doubleValue())).getValue();
        }
        if (object instanceof Long) {
            return NSNumber.static_numberWithLongLong(new Int64(((Long)object).longValue())).getValue();
        }
        if (object instanceof Boolean) {
            return NSNumber.static_numberWithBool((Boolean)object).getValue();
        }
        return 0L;
    }
}

