/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.webkit;

import com.teamdev.jxbrowser.webkit.BrowserEngine;
import com.teamdev.jxbrowser.webkit.SafariEngine;
import com.teamdev.jxbrowser.webkit.event.BrowserAdapter;
import com.teamdev.jxbrowser.webkit.event.BrowserEvent;
import com.teamdev.jxbrowser.webkit.event.BrowserListener;
import com.teamdev.jxbrowser.webkit.webkit.DOMElement;
import com.teamdev.jxbrowser.webkit.webkit.DOMEvent;
import com.teamdev.jxbrowser.webkit.webkit.DOMFactory;
import com.teamdev.jxbrowser.webkit.webkit.DOMKeyboardEvent;
import com.teamdev.jxbrowser.webkit.webkit.DOMMouseEvent;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

public class MouseKeyboardSupport
implements EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(MouseKeyboardSupport.class);
    private static final String[] events = new String[]{"click", "dblclick", "mousedown", "mouseup", "mousemove", "keydown", "keyup", "keypress"};
    private final Component component;
    private final BrowserEngine engine;
    private final BrowserListener listener;

    public MouseKeyboardSupport(Component component, BrowserEngine browserEngine) {
        this.component = component;
        this.engine = browserEngine;
        this.listener = new DownloadListener();
        this.engine.addBrowserListener(this.listener);
    }

    public void dispose() {
        this.engine.removeBrowserListener(this.listener);
    }

    private void registerListeners() {
        Document document = this.engine.getDocument();
        Element element = document.getDocumentElement();
        DOMFactory dOMFactory = ((SafariEngine)this.engine).getDomFactory();
        DOMElement dOMElement = (DOMElement)dOMFactory.unwrap(element);
        for (String string : events) {
            this.engine.addEventListener(dOMElement, string, this, true);
        }
    }

    public void unregisterListeners() {
        Document document = this.engine.getDocument();
        Element element = document.getDocumentElement();
        DOMFactory dOMFactory = ((SafariEngine)this.engine).getDomFactory();
        DOMElement dOMElement = (DOMElement)dOMFactory.unwrap(element);
        for (String string : events) {
            this.engine.removeEventListener(dOMElement, string, this, true);
        }
    }

    public void handleEvent(Event event) {
        DOMFactory dOMFactory = ((SafariEngine)this.engine).getDomFactory();
        DOMEvent dOMEvent = (DOMEvent)dOMFactory.unwrap(event);
        if (dOMEvent.isMouseEvent()) {
            this.fireAWTEvent(new DOMMouseEvent(dOMEvent.getPointer(), dOMFactory));
        } else if (dOMEvent.isKeyEvent()) {
            this.fireAWTEvent(new DOMKeyboardEvent(dOMEvent.getPointer(), dOMFactory));
        }
    }

    private void fireAWTEvent(DOMKeyboardEvent dOMKeyboardEvent) {
        int n;
        String string = dOMKeyboardEvent.getType();
        if (string.equals("keydown")) {
            n = 401;
        } else if (string.equals("keyup")) {
            n = 402;
        } else if (string.equals("keypress")) {
            n = 400;
        } else {
            LOG.error("Unknown key event type " + string);
            return;
        }
        final long l = System.currentTimeMillis();
        int n2 = 0;
        if (dOMKeyboardEvent.getShiftKey()) {
            n2 |= 0x40;
        }
        if (dOMKeyboardEvent.getCtrlKey()) {
            n2 |= 0x80;
        }
        if (dOMKeyboardEvent.getMetaKey()) {
            n2 |= 0x100;
        }
        if (dOMKeyboardEvent.getAltKey()) {
            n2 |= 0x200;
        }
        final int n3 = n2;
        long l2 = dOMKeyboardEvent.getKeyCode();
        long l3 = dOMKeyboardEvent.getCharCode();
        final int n4 = n != 400 ? (int)l2 : 0;
        final char c = l3 != 0L ? (char)l3 : (char)'\u0000';
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                KeyEvent keyEvent = new KeyEvent(MouseKeyboardSupport.this.component, n, l, n3, n4, c);
                if (c == '\u0000' && !keyEvent.isActionKey()) {
                    char c2 = (char)n4;
                    if (Character.isLetter(c2) && (n3 & 0x40) == 0) {
                        c2 = Character.toLowerCase(c2);
                    }
                    keyEvent.setKeyChar(c2);
                }
                MouseKeyboardSupport.this.component.dispatchEvent(keyEvent);
            }
        });
    }

    private void fireAWTEvent(DOMMouseEvent dOMMouseEvent) {
        int n;
        String string = dOMMouseEvent.getType();
        if (string.equals("click") || string.equals("dblclick")) {
            n = 500;
        } else if (string.equals("mousedown")) {
            n = 501;
        } else if (string.equals("mouseup")) {
            n = 502;
        } else if (string.equals("mousemove")) {
            n = 503;
        } else {
            LOG.error("Unknown mouse event type " + string);
            return;
        }
        final long l = System.currentTimeMillis();
        int n2 = 0;
        if (dOMMouseEvent.getShiftKey()) {
            n2 |= 0x40;
        }
        if (dOMMouseEvent.getCtrlKey()) {
            n2 |= 0x80;
        }
        if (dOMMouseEvent.getMetaKey()) {
            n2 |= 0x100;
        }
        if (dOMMouseEvent.getAltKey()) {
            n2 |= 0x200;
        }
        if (dOMMouseEvent.getButton() == 0) {
            n2 |= 0x400;
        }
        if (dOMMouseEvent.getButton() == 1) {
            n2 |= 0x800;
        }
        if (dOMMouseEvent.getButton() == 2) {
            n2 |= 0x1000;
        }
        final int n3 = n2;
        final int n4 = dOMMouseEvent.getClientX();
        final int n5 = dOMMouseEvent.getClientY();
        int n6 = 0;
        if ("click".equals(dOMMouseEvent.getType())) {
            n6 = 1;
        } else if ("dblclick".equals(dOMMouseEvent.getType())) {
            n6 = 2;
        }
        final int n7 = n6;
        final int n8 = dOMMouseEvent.getButton() == 0 ? 1 : (dOMMouseEvent.getButton() == 1 ? 2 : (dOMMouseEvent.getButton() == 2 ? 3 : 0));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MouseEvent mouseEvent = new MouseEvent(MouseKeyboardSupport.this.component, n, l, n3, n4, n5, n7, false, n8);
                MouseKeyboardSupport.this.component.dispatchEvent(mouseEvent);
            }
        });
    }

    private class DownloadListener
    extends BrowserAdapter {
        private DownloadListener() {
        }

        public void onDownloadComplete(BrowserEvent browserEvent) {
            MouseKeyboardSupport.this.registerListeners();
        }

        public void onDownloadBegin(BrowserEvent browserEvent) {
            MouseKeyboardSupport.this.unregisterListeners();
        }
    }
}

