/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.webkit;

import com.jniwrapper.PlatformContext;
import com.teamdev.jxbrowser.webkit.DefaultDialogCreator;
import com.teamdev.jxbrowser.webkit.DefaultWindowCreator;
import com.teamdev.jxbrowser.webkit.DialogCreator;
import com.teamdev.jxbrowser.webkit.WebBrowser;
import com.teamdev.jxbrowser.webkit.WindowCreator;

public class WebBrowserFactory {
    private DialogCreator dialogCreator = new DefaultDialogCreator();
    private WindowCreator windowCreator = new DefaultWindowCreator();

    public WebBrowser createBrowser() {
        try {
            WebBrowser webBrowser;
            if (PlatformContext.isMacOS()) {
                webBrowser = (WebBrowser)Class.forName("com.teamdev.jxbrowser.webkit.Safari").newInstance();
            } else if (PlatformContext.isWindows()) {
                webBrowser = (WebBrowser)Class.forName("teamdev.jxbrowser.win.InternetExplorer").newInstance();
            } else {
                throw new IllegalStateException("Unsupported Operation System");
            }
            webBrowser.setDialogCreator(this.getDefaultDialogCreator());
            webBrowser.setWindowCreator(this.getDefaultWindowCreator());
            return webBrowser;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    public DialogCreator getDefaultDialogCreator() {
        return this.dialogCreator;
    }

    public WindowCreator getDefaultWindowCreator() {
        return this.windowCreator;
    }
}

