/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.analyzer;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Vector;
import org.wsi.WSIException;
import org.wsi.test.ToolInfo;
import org.wsi.test.analyzer.AnalyzerContext;
import org.wsi.test.analyzer.CandidateInfo;
import org.wsi.test.analyzer.config.AnalyzerConfig;
import org.wsi.test.document.DocumentFactory;
import org.wsi.test.log.Log;
import org.wsi.test.profile.ProfileAssertions;
import org.wsi.test.profile.validator.ProfileValidatorFactory;
import org.wsi.test.report.Reporter;
import org.wsi.test.util.TestUtils;
import org.wsi.util.MessageList;

public abstract class Analyzer {
    protected MessageList messageList = null;
    protected static final String RESOURCE_BUNDLE_NAME = "org.wsi.test.analyzer.Analyzer";
    public static final String USAGE_MESSAGE = "Usage: Analyzer -config <configFilename>";
    protected Reporter reporter = null;
    protected AnalyzerContext analyzerContext = null;
    protected CandidateInfo candidateInfo = null;
    protected ToolInfo toolInfo = null;
    protected ProfileValidatorFactory factory = null;
    protected DocumentFactory documentFactory = null;
    protected List analyzerConfigList = new Vector();
    protected int analyzerConfigIndex = 0;
    protected ProfileAssertions profileAssertions = null;
    protected Log log = null;

    public Analyzer(String[] stringArray, ToolInfo toolInfo) throws WSIException {
        this.init(toolInfo);
        this.analyzerConfigList.add(this.analyzerConfigIndex, this.documentFactory.newAnalyzerConfig());
        this.getAnalyzerConfig().init(this.messageList);
        this.getAnalyzerConfig().parseArgs(stringArray, true);
        TestUtils.printToolInfo(toolInfo);
        System.out.println(((Object)this.getAnalyzerConfig()).toString());
        this.printMessage("progress01", null, "Please wait while the specified artifacts are analyzed...");
    }

    public Analyzer(String[] stringArray, ToolInfo toolInfo, boolean bl) throws WSIException {
        this.init(toolInfo);
        this.analyzerConfigList.add(this.analyzerConfigIndex, this.documentFactory.newAnalyzerConfig());
        this.getAnalyzerConfig().init(this.messageList);
        this.getAnalyzerConfig().parseArgs(stringArray, bl);
        TestUtils.printToolInfo(toolInfo);
        System.out.println(((Object)this.getAnalyzerConfig()).toString());
        this.printMessage("progress01", null, "Please wait while the specified artifacts are analyzed...");
    }

    public Analyzer(List list, ToolInfo toolInfo) throws WSIException {
        this.init(toolInfo);
        this.analyzerConfigList = list;
    }

    protected void init(ToolInfo toolInfo) throws WSIException {
        this.toolInfo = toolInfo;
        this.messageList = new MessageList(RESOURCE_BUNDLE_NAME);
        this.factory = ProfileValidatorFactory.newInstance();
        this.documentFactory = DocumentFactory.newInstance();
    }

    public int validateAll() throws WSIException {
        int n = 0;
        for (int i = 0; i < this.analyzerConfigList.size(); ++i) {
            this.setAnalyzerConfig(i);
            int n2 = this.validateConformance();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public abstract int validateConformance() throws WSIException;

    public ToolInfo getToolInfo() {
        return this.toolInfo;
    }

    protected void setAnalyzerConfig(int n) {
        this.analyzerConfigIndex = n;
    }

    public AnalyzerConfig getAnalyzerConfig() {
        return (AnalyzerConfig)this.analyzerConfigList.get(this.analyzerConfigIndex);
    }

    public void printMessage(String string, String string2, String string3) {
        this.messageList.printMessage(string, string2, string3);
    }

    public static void staticPrintMessage(String string, String string2, String string3) {
        MessageList.printMessage(RESOURCE_BUNDLE_NAME, string, string2, string3);
    }

    public String toXMLString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print(this.toolInfo.getStartXMLString(string));
        printWriter.print(this.getAnalyzerConfig().toXMLString("wsi-analyzerConfig"));
        printWriter.println(this.toolInfo.getEndXMLString(string));
        return stringWriter.toString();
    }

    public void printMessage(String string) {
        if (this.getAnalyzerConfig().getVerboseOption()) {
            System.err.println(string);
        }
    }
}

