/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.analyzer;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.apache.xerces.util.URI;
import org.wsi.WSIException;
import org.wsi.test.analyzer.ServiceReference;
import org.wsi.test.analyzer.config.WSDLElement;
import org.wsi.wsdl.WSDLDocument;
import org.wsi.wsdl.WSDLUtils;

public class CandidateInfo {
    private Definition[] definitions = null;
    private Import[] imports = null;
    private Types[] types = null;
    private Message[] messages = null;
    private Operation[] operations = null;
    private PortType[] portTypes = null;
    private Binding[] bindings = null;
    private Port[] ports = null;
    private URI[] endPoints = null;
    private WSDLDocument wsdlDocument;

    public CandidateInfo(ServiceReference serviceReference, WSDLDocument wSDLDocument) throws WSIException {
        int n;
        WSDLElement wSDLElement = serviceReference.getWSDLElement();
        this.wsdlDocument = wSDLDocument;
        this.imports = this.getAllImports(wSDLDocument.getDefinitions()).toArray(new Import[0]);
        this.definitions = new Definition[this.imports.length + 1];
        this.definitions[0] = wSDLDocument.getDefinitions();
        Types[] typesArray = new Types[this.definitions.length];
        int n2 = 0;
        if (this.definitions[0].getTypes() != null) {
            typesArray[0] = this.definitions[0].getTypes();
            ++n2;
        }
        for (n = 0; n < this.imports.length; ++n) {
            this.definitions[n + 1] = this.imports[n].getDefinition();
            if (this.definitions[n + 1] == null || this.definitions[n + 1].getTypes() == null) continue;
            typesArray[n2] = this.definitions[n + 1].getTypes();
            ++n2;
        }
        if (n2 > 0) {
            this.types = new Types[n2];
            for (n = 0; n < n2; ++n) {
                this.types[n] = typesArray[n];
            }
        }
        if (wSDLElement.isPort()) {
            Port port = null;
            QName qName = wSDLElement.getParentElementQName();
            Service[] serviceArray = wSDLDocument.getServices();
            String string = wSDLElement.getName();
            for (int i = 0; i < serviceArray.length && port == null; ++i) {
                if (!serviceArray[i].getQName().equals(qName)) continue;
                port = serviceArray[i].getPort(string);
            }
            if (port == null) {
                throw new WSIException("WSDL Port '" + string + "' for Service '" + qName + "' not found in service description");
            }
            this.ports = new Port[]{port};
            this.descendents(port);
        } else if (wSDLElement.isBinding()) {
            if (wSDLElement.getQName() != null && wSDLElement.getQName().getLocalPart() != null && wSDLElement.getQName().getLocalPart().length() > 0) {
                Binding binding = wSDLDocument.getDefinitions().getBinding(wSDLElement.getQName());
                if (binding == null) {
                    throw new WSIException("WSDL Binding named '" + wSDLElement.getQName() + "' not found in service description");
                }
                this.bindings = new Binding[]{binding};
                this.descendents(binding);
            }
        } else if (wSDLElement.isPortType()) {
            PortType portType = wSDLDocument.getDefinitions().getPortType(wSDLElement.getQName());
            this.portTypes = new PortType[]{portType};
            if (portType == null) {
                throw new WSIException("WSDL PortType named '" + wSDLElement.getQName() + "' not found in service description");
            }
            this.portTypes = new PortType[]{portType};
            this.descendents(portType);
        } else if (wSDLElement.isOperation()) {
            Operation operation = null;
            String string = wSDLElement.getName();
            QName qName = wSDLElement.getParentElementQName();
            PortType[] portTypeArray = wSDLDocument.getPortTypes();
            for (int i = 0; i < portTypeArray.length && operation == null; ++i) {
                if (!portTypeArray[i].getQName().equals(qName)) continue;
                Iterator iterator = portTypeArray[i].getOperations().iterator();
                Operation operation2 = null;
                while (iterator.hasNext() && operation == null) {
                    operation2 = (Operation)iterator.next();
                    if (!string.equals(operation2.getName())) continue;
                    operation = operation2;
                }
            }
            if (operation == null) {
                throw new WSIException("No WSDL Operation named '" + wSDLElement.getQName() + "' found in service description");
            }
            this.operations = new Operation[]{operation};
            this.descendents(operation);
        } else if (wSDLElement.isMessage()) {
            Message message = wSDLDocument.getDefinitions().getMessage(wSDLElement.getQName());
            if (message == null) {
                throw new WSIException("No WSDL Message named '" + wSDLElement.getQName() + "' found in service description");
            }
            this.messages = new Message[]{message};
        } else {
            throw new WSIException("Unrecognised <WSDLElement type> in config: " + wSDLElement.getType());
        }
        this.endPoints = this.deriveEndpoints(serviceReference, this.ports, this.definitions);
    }

    protected void descendents(Port port) throws WSIException {
        if (port == null) {
            throw new WSIException("Internal error: expected a Port value");
        }
        this.bindings = new Binding[]{port.getBinding()};
        if (this.bindings[0] != null) {
            this.descendents(this.bindings[0]);
        }
    }

    protected void descendents(Binding binding) throws WSIException {
        if (binding == null) {
            throw new WSIException("Internal error: expected a Binding value");
        }
        this.portTypes = new PortType[]{binding.getPortType()};
        if (this.portTypes[0] != null) {
            this.descendents(this.portTypes[0]);
            Definition definition = this.definitions[0];
            HashSet<Message> hashSet = new HashSet<Message>();
            if (this.messages != null) {
                for (int i = 0; i < this.messages.length; ++i) {
                    hashSet.add(this.messages[i]);
                }
            }
            HashSet hashSet2 = WSDLUtils.findMessages(definition, binding);
            hashSet.addAll(hashSet2);
            this.messages = new Message[0];
            this.messages = hashSet.toArray(this.messages);
        }
    }

    protected void descendents(PortType portType) throws WSIException {
        if (portType == null) {
            throw new WSIException("Internal error: expected a PortType value");
        }
        this.operations = new Operation[0];
        this.operations = portType.getOperations().toArray(this.operations);
        if (this.operations.length > 0) {
            this.descendents(this.operations);
        }
    }

    protected void descendents(Operation operation) throws WSIException {
        if (operation == null) {
            throw new WSIException("Internal error: expected an Operation value");
        }
        this.descendents(new Operation[]{operation});
    }

    protected void descendents(Operation[] operationArray) throws WSIException {
        if (operationArray == null) {
            throw new WSIException("Internal error: expected an Operation[] value");
        }
        HashSet<Message> hashSet = new HashSet<Message>();
        for (int i = 0; i < operationArray.length; ++i) {
            if (operationArray[i].getInput() != null) {
                hashSet.add(operationArray[i].getInput().getMessage());
            }
            if (operationArray[i].getOutput() != null) {
                hashSet.add(operationArray[i].getOutput().getMessage());
            }
            Iterator iterator = operationArray[i].getFaults().values().iterator();
            while (iterator.hasNext()) {
                hashSet.add(((Fault)iterator.next()).getMessage());
            }
        }
        this.messages = new Message[0];
        this.messages = hashSet.toArray(this.messages);
    }

    private HashSet getAllImports(Definition definition) throws WSIException {
        HashSet<Import> hashSet = new HashSet<Import>();
        Map map = definition.getImports();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                Import import_ = (Import)iterator2.next();
                if (import_ == null) continue;
                hashSet.add(import_);
                if (import_.getDefinition() == null) continue;
                HashSet hashSet2 = this.getAllImports(import_.getDefinition());
                Iterator iterator3 = hashSet2.iterator();
                while (iterator3.hasNext()) {
                    hashSet.add((Import)iterator3.next());
                }
            }
        }
        return hashSet;
    }

    private URI[] deriveEndpoints(ServiceReference serviceReference, Port[] portArray, Definition[] definitionArray) {
        URI[] uRIArray = null;
        try {
            String string = null;
            string = serviceReference.getServiceLocation();
            if (string != null) {
                uRIArray = new URI[]{new URI(string)};
            } else if (serviceReference.getWSDLElement().isPort()) {
                if (portArray.length != 1) {
                    throw new WSIException("Internal error - expected 1-element Port array");
                }
                Iterator iterator = portArray[0].getExtensibilityElements().iterator();
                while (iterator.hasNext() && string == null) {
                    ExtensibilityElement extensibilityElement = (ExtensibilityElement)iterator.next();
                    if (!(extensibilityElement instanceof SOAPAddress)) continue;
                    string = ((SOAPAddress)extensibilityElement).getLocationURI();
                    uRIArray = new URI[]{new URI(string)};
                }
            } else {
                HashSet<String> hashSet = new HashSet<String>();
                Iterator iterator = definitionArray[0].getExtensibilityElements().iterator();
                while (iterator.hasNext()) {
                    ExtensibilityElement extensibilityElement = (ExtensibilityElement)iterator.next();
                    if (!(extensibilityElement instanceof SOAPAddress)) continue;
                    hashSet.add(((SOAPAddress)extensibilityElement).getLocationURI());
                }
                uRIArray = new URI[]{};
                uRIArray = hashSet.toArray(uRIArray);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uRIArray;
    }

    public Binding[] getBindings() {
        return this.bindings;
    }

    public URI[] getEndPoints() {
        return this.endPoints;
    }

    public URI[] getEndPoints(String string) {
        Vector<URI> vector = new Vector<URI>();
        for (int i = 0; i < this.endPoints.length; ++i) {
            String string2;
            String string3 = string2 = this.endPoints[i].getPort() == -1 ? "80" : String.valueOf(this.endPoints[i].getPort());
            if (!string.equals(this.endPoints[i].getHost() + ":" + string2)) continue;
            vector.add(this.endPoints[i]);
        }
        return vector.toArray(new URI[0]);
    }

    public Operation[] getOperations() {
        return this.operations;
    }

    public PortType[] getPortType() {
        return this.portTypes;
    }

    public boolean hasHostAndPort(String string) throws WSIException {
        URI uRI;
        try {
            uRI = new URI(string);
        }
        catch (Exception exception) {
            throw new WSIException("Could not convert string to URI: " + string);
        }
        String string2 = uRI.getHost();
        int n = uRI.getPort();
        for (int i = 0; i < this.endPoints.length; ++i) {
            if (!this.endPoints[i].getHost().equals(string2) || this.endPoints[i].getPort() != n) continue;
            return true;
        }
        return false;
    }

    public Definition[] getDefinitions() {
        return this.definitions;
    }

    public Import[] getImports() {
        return this.imports;
    }

    public Message[] getMessages() {
        return this.messages;
    }

    public Port[] getPorts() {
        return this.ports;
    }

    public PortType[] getPortTypes() {
        return this.portTypes;
    }

    public Types[] getTypes() {
        return this.types;
    }

    public WSDLDocument getWsdlDocument() {
        return this.wsdlDocument;
    }

    public Definition getDefinition(Types types) {
        Definition definition = null;
        for (int i = 0; i < this.definitions.length && definition == null; ++i) {
            Types types2 = this.definitions[i].getTypes();
            if (types2 == null || !types2.equals(types)) continue;
            definition = this.definitions[i];
        }
        return definition;
    }

    public Definition getDefinition(Binding binding) {
        Definition definition = null;
        for (int i = 0; i < this.definitions.length && definition == null; ++i) {
            if (this.definitions[i].getBinding(binding.getQName()) == null) continue;
            definition = this.definitions[i];
        }
        return definition;
    }

    public Definition getDefinition(PortType portType) {
        Definition definition = null;
        for (int i = 0; i < this.definitions.length && definition == null; ++i) {
            if (this.definitions[i].getPortType(portType.getQName()) == null) continue;
            definition = this.definitions[i];
        }
        return definition;
    }

    public Definition getDefinition(Message message) {
        Definition definition = null;
        for (int i = 0; i < this.definitions.length && definition == null; ++i) {
            if (this.definitions[i].getMessage(message.getQName()) == null) continue;
            definition = this.definitions[i];
        }
        return definition;
    }
}

