/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.document;

import org.wsi.WSIException;
import org.wsi.test.analyzer.config.AnalyzerConfig;
import org.wsi.test.analyzer.config.AnalyzerConfigReader;
import org.wsi.test.log.Log;
import org.wsi.test.log.LogReader;
import org.wsi.test.log.LogWriter;
import org.wsi.test.monitor.config.MonitorConfig;
import org.wsi.test.monitor.config.MonitorConfigReader;
import org.wsi.test.profile.ProfileAssertions;
import org.wsi.test.profile.ProfileAssertionsReader;
import org.wsi.test.report.Report;
import org.wsi.test.report.ReportWriter;
import org.wsi.util.WSIProperties;

public abstract class DocumentFactory {
    public static DocumentFactory newInstance() throws WSIException {
        return DocumentFactory.newInstance(DocumentFactory.getFactoryClassName());
    }

    public static DocumentFactory newInstance(String string) throws WSIException {
        DocumentFactory documentFactory = null;
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                documentFactory = (DocumentFactory)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new WSIException("Could not instantiate document factory class: " + string + ".", exception);
            }
        } else {
            throw new WSIException("A WSIDocumentFactory implementation class was not found.");
        }
        return documentFactory;
    }

    public abstract Log newLog();

    public abstract MonitorConfig newMonitorConfig();

    public abstract AnalyzerConfig newAnalyzerConfig();

    public abstract ProfileAssertions newProfileAssertions();

    public abstract Report newReport();

    public abstract ProfileAssertionsReader newProfileAssertionsReader();

    public abstract MonitorConfigReader newMonitorConfigReader();

    public abstract AnalyzerConfigReader newAnalyzerConfigReader();

    public abstract LogReader newLogReader();

    public abstract ReportWriter newReportWriter();

    public abstract LogWriter newLogWriter();

    private static String getFactoryClassName() {
        return WSIProperties.getProperty("wsi.document.factory", "org.wsi.test.document.impl.DocumentFactoryImpl");
    }
}

