/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator;

import org.wsi.WSIException;
import org.wsi.test.profile.validator.EnvelopeValidator;
import org.wsi.test.profile.validator.MessageValidator;
import org.wsi.test.profile.validator.UDDIValidator;
import org.wsi.test.profile.validator.WSDLValidator;
import org.wsi.util.WSIProperties;

public abstract class ProfileValidatorFactory {
    public abstract UDDIValidator newUDDIValidator() throws WSIException;

    public abstract WSDLValidator newWSDLValidator() throws WSIException;

    public abstract MessageValidator newMessageValidator() throws WSIException;

    public abstract EnvelopeValidator newEnvelopeValidator() throws WSIException;

    public static ProfileValidatorFactory newInstance() throws WSIException {
        ProfileValidatorFactory profileValidatorFactory = null;
        String string = null;
        try {
            string = WSIProperties.getProperty("wsi.profile.validator.factory", "org.wsi.test.profile.validator.impl.ProfileValidatorFactoryImpl");
            Class<?> clazz = Class.forName(string);
            profileValidatorFactory = (ProfileValidatorFactory)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new WSIException("Could not instantiate factory class: " + string + ".", exception);
        }
        return profileValidatorFactory;
    }
}

