/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.envelope;

import java.util.List;
import javax.wsdl.BindingOperation;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.analyzer.AssertionNotApplicableException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.EntryType;

public class AP1920
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public AP1920(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            if (!entryContext.getMessageEntry().isMimeContent()) {
                throw new AssertionNotApplicableException();
            }
            if (entryContext.getMessageEntryDocument() == null || entryContext.getMessageEntryDocument().getElementsByTagNameNS(WSITag.ELEM_SOAP_FAULT.getNamespaceURI(), WSITag.ELEM_SOAP_FAULT.getLocalPart()).getLength() != 1) {
                throw new AssertionNotApplicableException();
            }
            BindingOperation bindingOperation = this.validator.getOperationMatch(EntryType.getEntryType("requestMessage"), entryContext.getRequestDocument());
            if (bindingOperation == null) {
                throw new AssertionNotApplicableException();
            }
            if (entryContext.getMessageEntry().getMimeParts().count() > 1 && this.getMultipartRelatedBindings(bindingOperation) == null) {
                this.result = "failed";
                this.failureDetail = this.validator.createFailureDetail("The message contains \"" + entryContext.getMessageEntry().getMimeParts().count() + "\" part(s)", entryContext);
            }
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private MIMEMultipartRelated getMultipartRelatedBindings(BindingOperation bindingOperation) {
        List list = bindingOperation.getBindingOutput().getExtensibilityElements();
        if (list == null || list.size() == 0 || !(list.get(0) instanceof MIMEMultipartRelated)) {
            return null;
        }
        return (MIMEMultipartRelated)list.get(0);
    }
}

