/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.envelope;

import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Message;
import javax.wsdl.Part;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wsi.WSIException;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.analyzer.AssertionNotApplicableException;
import org.wsi.test.analyzer.AssertionPassException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.OperationSignature;
import org.wsi.test.util.TypesRegistry;
import org.wsi.xml.XMLUtils;

public class BP1008
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1008(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            TypesRegistry typesRegistry;
            Binding binding;
            String string;
            if (this.validator.isOneWayResponse(entryContext)) {
                throw new AssertionFailException("notApplicable");
            }
            Document document = entryContext.getMessageEntryDocument();
            if (document == null) {
                throw new AssertionFailException();
            }
            if (this.validator.isFault(document)) {
                throw new AssertionFailException("notApplicable");
            }
            if (!this.validator.containsSoapBodyWithChild(document)) {
                throw new AssertionNotApplicableException();
            }
            Document document2 = entryContext.getRequestDocument();
            OperationSignature.OperationMatch operationMatch = OperationSignature.matchOperation(document2, string = this.validator.getSoapAction(entryContext.getRequest().getHTTPHeaders()), binding = this.validator.analyzerContext.getCandidateInfo().getBindings()[0], typesRegistry = new TypesRegistry(this.validator.getWSDLDocument().getDefinitions(), this.validator));
            if (operationMatch == null) {
                throw new AssertionNotApplicableException();
            }
            BindingOperation bindingOperation = operationMatch.getOperation();
            if (!"rpc".equals(operationMatch.getOperationStyle())) {
                throw new AssertionFailException("notApplicable");
            }
            NodeList nodeList = document.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");
            if (nodeList.getLength() == 0 || nodeList.getLength() > 1) {
                throw new AssertionFailException();
            }
            Element element = (Element)nodeList.item(0);
            this.result = null;
            Element element2 = XMLUtils.getFirstChild(element);
            if (element2 == null) {
                throw new AssertionFailException();
            }
            Message message = null;
            List list = null;
            if ("request".equals(entryContext.getMessageEntry().getType())) {
                message = bindingOperation.getOperation().getInput().getMessage();
                if (bindingOperation.getBindingInput() != null) {
                    list = bindingOperation.getBindingInput().getExtensibilityElements();
                }
            } else if ("response".equals(entryContext.getMessageEntry().getType())) {
                message = bindingOperation.getOperation().getOutput().getMessage();
                if (bindingOperation.getBindingOutput() != null) {
                    list = bindingOperation.getBindingOutput().getExtensibilityElements();
                }
            }
            if (!this.validator.isLiteral(list)) {
                throw new AssertionFailException("notApplicable");
            }
            Element element3 = XMLUtils.getFirstChild(element2);
            if (element3 == null) {
                throw new AssertionPassException();
            }
            while (element3 != null) {
                if (element3.getNamespaceURI() != null || "".equals(element3.getNamespaceURI())) {
                    throw new AssertionFailException();
                }
                String string2 = this.getTypeNS(message, element3.getLocalName());
                if (string2 == null) {
                    throw new AssertionFailException();
                }
                if (!this.checkChildrenNamespace(element3, string2)) {
                    throw new AssertionFailException();
                }
                element3 = XMLUtils.getNextSibling(element3);
            }
            this.result = "passed";
        }
        catch (AssertionFailException assertionFailException) {
            this.result = assertionFailException.getMessage() != null && assertionFailException.getMessage().length() > 0 ? assertionFailException.getMessage() : "failed";
        }
        catch (AssertionPassException assertionPassException) {
            this.result = "passed";
        }
        catch (Exception exception) {
            this.result = "notApplicable";
        }
        if (this.result == "failed") {
            this.failureDetail = this.validator.createFailureDetail(null, entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private String getTypeNS(Message message, String string) {
        Part part = message.getPart(string);
        if (part == null) {
            return null;
        }
        return part.getTypeName().getNamespaceURI();
    }

    private boolean checkChildrenNamespace(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName("*");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (!string.equals(element2.getNamespaceURI())) {
                return false;
            }
            if (this.checkChildrenNamespace(element2, string)) continue;
            return false;
        }
        return true;
    }
}

