/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.envelope;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wsi.WSIException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.util.Utils;

public class BP1100
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1100(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        if (this.validator.isOneWayResponse(entryContext)) {
            this.result = "notApplicable";
        } else {
            Document document = entryContext.getMessageEntryDocument();
            if (document == null) {
                this.result = "notApplicable";
            } else {
                Element element = document.getDocumentElement();
                NodeList nodeList = element.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
                if (nodeList == null || nodeList.getLength() == 0) {
                    String string = Utils.getHTTPStatusCode(entryContext.getMessageEntry().getHTTPHeaders());
                    if (!"200".equals(string)) {
                        this.result = "warning";
                        this.failureDetail = this.validator.createFailureDetail("\nResponse message:\nHeaders:\n" + entryContext.getMessageEntry().getHTTPHeaders() + "\nMessage:\n" + entryContext.getMessageEntry().getMessage(), entryContext);
                    }
                } else {
                    this.result = "notApplicable";
                }
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

