/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.envelope;

import java.util.Collection;
import java.util.Iterator;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wsi.WSIException;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.analyzer.AssertionNotApplicableException;
import org.wsi.test.analyzer.AssertionPassException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.OperationSignature;
import org.wsi.test.util.TypesRegistry;
import org.wsi.util.HTTPUtils;
import org.wsi.xml.XMLUtils;

public class BP1204
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1204(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            Object object;
            Object object2;
            TypesRegistry typesRegistry;
            Binding binding;
            OperationSignature.OperationMatch operationMatch;
            if (this.validator.isOneWayResponse(entryContext)) {
                throw new AssertionNotApplicableException();
            }
            Document document = XMLUtils.parseXML(entryContext.getMessageEntry().getMessage());
            if (this.validator.isFault(document)) {
                throw new AssertionPassException();
            }
            Document document2 = XMLUtils.parseXML(entryContext.getRequest().getMessage());
            String string = entryContext.getRequest().getHTTPHeaders();
            String string2 = null;
            if (string != null) {
                string2 = (String)HTTPUtils.getHttpHeaderTokens(string, ":").get("SOAPAction");
            }
            if ((operationMatch = OperationSignature.matchOperation(document2, string2, binding = this.validator.analyzerContext.getCandidateInfo().getBindings()[0], typesRegistry = new TypesRegistry(this.validator.getWSDLDocument().getDefinitions(), this.validator))) == null) {
                throw new AssertionPassException();
            }
            BindingOperation bindingOperation = operationMatch.getOperation();
            Message message = null;
            if ("request".equals(entryContext.getMessageEntry().getType()) && bindingOperation.getOperation().getInput() != null) {
                message = bindingOperation.getOperation().getInput().getMessage();
            } else if ("response".equals(entryContext.getMessageEntry().getType()) && bindingOperation.getOperation().getOutput() != null) {
                message = bindingOperation.getOperation().getOutput().getMessage();
            }
            if (message == null) {
                throw new AssertionPassException();
            }
            boolean bl = false;
            Collection collection = message.getParts().values();
            Object object3 = collection.iterator();
            while (object3.hasNext()) {
                object2 = (Part)object3.next();
                object = null;
                object = object2.getTypeName() == null ? typesRegistry.getType(object2.getElementName()) : object2.getTypeName();
                bl = typesRegistry.isExtendsArray((QName)object) || typesRegistry.isUsesWSDLArrayType((QName)object) || this.isArrayType((QName)object);
                if (!bl) continue;
            }
            if (bl) {
                object3 = document.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");
                if (object3.getLength() == 0 || object3.getLength() > 1) {
                    throw new AssertionFailException();
                }
                object2 = (Element)object3.item(0);
                object = object2.getElementsByTagNameNS("*", "*");
                for (int i = 0; i < object.getLength(); ++i) {
                    Element element = (Element)object.item(i);
                    if (!element.hasAttributeNS("http://schemas.xmlsoap.org/soap/encoding/", "arrayType")) continue;
                    throw new AssertionFailException();
                }
                throw new AssertionPassException();
            }
            throw new AssertionPassException();
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException assertionFailException) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(entryContext.getMessageEntry().getMessage(), entryContext);
        }
        catch (AssertionPassException assertionPassException) {
            this.result = "passed";
        }
        catch (Exception exception) {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private boolean isArrayType(QName qName) {
        NodeList nodeList;
        boolean bl = false;
        Element element = this.getTypeElement(qName);
        if (element != null && (nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "sequence")).getLength() > 0) {
            bl = true;
        }
        return bl;
    }

    private Element getTypeElement(QName qName) {
        Types[] typesArray = this.validator.analyzerContext.getCandidateInfo().getTypes();
        for (int i = 0; typesArray != null && i < typesArray.length; ++i) {
            Object object;
            Object object2;
            Element element = null;
            if (typesArray[i] == null) continue;
            element = typesArray[i].getDocumentationElement();
            if (element == null) {
                object2 = typesArray[i].getExtensibilityElements();
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = (ExtensibilityElement)iterator.next();
                    if (!object.getElementType().equals(new QName("http://www.w3.org/2001/XMLSchema", "schema"))) continue;
                    element = ((UnknownExtensibilityElement)object).getElement();
                    break;
                }
            }
            if (element == null) continue;
            object2 = element.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "complexType");
            for (int j = 0; j < object2.getLength(); ++j) {
                object = (Element)object2.item(j);
                if (!qName.getLocalPart().equals(object.getAttribute("name"))) continue;
                return object;
            }
        }
        return null;
    }
}

