/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.message;

import java.util.ArrayList;
import java.util.Iterator;
import org.wsi.WSIException;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.log.MimePart;
import org.wsi.test.log.MimeParts;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.util.HTTPUtils;
import org.wsi.util.Utils;

public class AP1935
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public AP1935(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        if (!entryContext.getMessageEntry().isMimeContent()) {
            this.result = "notApplicable";
        } else {
            MimeParts mimeParts = entryContext.getMessageEntry().getMimeParts();
            if (mimeParts.count() == 0) {
                this.result = "notApplicable";
            } else {
                Iterator iterator = mimeParts.getParts().iterator();
                int n = 0;
                MimePart mimePart = mimeParts.getRootPart();
                while (iterator.hasNext()) {
                    n = 1;
                    n = 1;
                    try {
                        MimePart mimePart2 = (MimePart)iterator.next();
                        String string = HTTPUtils.getHttpHeaderAttribute(mimePart2.getHeaders(), "Content-Transfer-Encoding");
                        if (mimePart2 == mimePart || string != null && string.equalsIgnoreCase("base64")) {
                            this.checkPart(mimePart2, string, false);
                            continue;
                        }
                        this.checkPart(mimePart2, string, true);
                    }
                    catch (AssertionFailException assertionFailException) {
                        this.result = "failed";
                        this.failureDetail = this.validator.createFailureDetail("part " + (n + 1) + " Error: " + assertionFailException.getMessage(), entryContext);
                    }
                }
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private void checkPart(MimePart mimePart, String string, boolean bl) throws AssertionFailException, WSIException {
        String string2 = null;
        string2 = bl ? new String(Utils.decodeBase64(mimePart.getContent())) : mimePart.getContent();
        if (string == null) {
            this.result = "notApplicable";
        } else if (string.equalsIgnoreCase("7bit")) {
            this.checkOn7bit(string2);
        } else if (string.equalsIgnoreCase("8bit")) {
            this.checkOn8bit(string2);
        } else if (string.equalsIgnoreCase("quoted-printable")) {
            this.checkOnQuotedPrintable(string2);
        } else if (string.equalsIgnoreCase("base64")) {
            this.checkOnBase64(string2);
        }
    }

    private void checkOn7bit(String string) throws AssertionFailException {
        String[] stringArray = this.split(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.length() > 998) {
                throw new AssertionFailException("The length (" + string2.length() + ") of the line (" + (i + 1) + ") greater than 998");
            }
            char[] cArray = string2.toCharArray();
            for (int j = 0; j < cArray.length; ++j) {
                if (cArray[j] <= '\u007f' && cArray[j] != '\u0000' && cArray[j] != '\n' && cArray[j] != '\r') continue;
                throw new AssertionFailException("The char (" + cArray[j] + ")[code=" + (byte)cArray[j] + " position=" + j + "] does not allows in 7bit encoding content");
            }
        }
    }

    private void checkOn8bit(String string) throws AssertionFailException {
        String[] stringArray = this.split(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.length() > 998) {
                throw new AssertionFailException("The length (" + string2.length() + ") of the line (" + (i + 1) + ") greater than 998");
            }
            char[] cArray = string2.toCharArray();
            for (int j = 0; j < cArray.length; ++j) {
                if (cArray[j] != '\u0000' && cArray[j] != '\n' && cArray[j] != '\r') continue;
                throw new AssertionFailException("The char (" + cArray[j] + ")[code=" + (byte)cArray[j] + " position=" + j + "] does not allows in 8bit encoding content");
            }
        }
    }

    private void checkOnQuotedPrintable(String string) throws AssertionFailException {
        String[] stringArray = this.split(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if ((stringArray[i].indexOf("\t") != -1 || stringArray[i].indexOf(" ") != -1) && stringArray[i].length() > 76) {
                throw new AssertionFailException("The length (" + stringArray[i].length() + ") of the line (" + (i + 1) + ") greater than 76, \"soft\" line breaks must be used");
            }
            char[] cArray = stringArray[i].toCharArray();
            for (int j = 0; j < cArray.length; ++j) {
                if (cArray[j] == '=' && cArray.length > j + 2) {
                    if (!this.isHex(cArray[j + 1]) || !this.isHex(cArray[j + 2])) {
                        throw new AssertionFailException("the quoted char (" + cArray[j] + cArray[j + 1] + cArray[j + 2] + ") is incorrect");
                    }
                    j += 2;
                    continue;
                }
                if (cArray[j] == '\t' || cArray[j] == ' ' || cArray[j] != '\u0000' && cArray[j] != '\n' && cArray[j] != '\r' && cArray[j] >= '!' && cArray[j] <= '~' && cArray[j] != '=') continue;
                throw new AssertionFailException("The char (" + cArray[j] + ")[code=" + (byte)cArray[j] + " position=" + j + "] must be quoted");
            }
        }
    }

    private void checkOnBase64(String string) throws AssertionFailException {
        String[] stringArray = this.split(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.length() > 76) {
                throw new AssertionFailException("The length (" + string2.length() + ") of the line (" + (i + 1) + ") greater than 998");
            }
            char[] cArray = string2.toCharArray();
            for (int j = 0; j < cArray.length; ++j) {
                char c = cArray[i];
                if (c >= '/' && c <= 'z' && (c <= '9' || c >= 'A') && (c <= 'Z' || c >= 'a')) continue;
                throw new AssertionFailException("The char (" + cArray[j] + ")[code=" + (byte)cArray[j] + " position=" + j + "] does not allows in base64 encoding content");
            }
        }
    }

    private String[] split(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.indexOf("\r\n");
        while (n != -1) {
            arrayList.add(string.substring(0, n));
            string = string.substring(n + 2);
            n = string.indexOf("\r\n");
        }
        arrayList.add(string);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F';
    }
}

