/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.uddi;

import org.uddi4j.datatype.tmodel.TModel;
import org.wsi.WSIException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.uddi.UDDIValidatorImpl;
import org.wsi.test.report.AssertionResult;

public class BP3003
extends AssertionProcess {
    private final UDDIValidatorImpl validator;

    public BP3003(UDDIValidatorImpl uDDIValidatorImpl) {
        super(uDDIValidatorImpl);
        this.validator = uDDIValidatorImpl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "passed";
        TModel tModel = (TModel)entryContext.getEntry().getEntryDetail();
        if (tModel == null) {
            this.result = "failed";
            this.failureDetailMessage = "Could not locate a tModel with a categorization of 'wsdlSpec'.";
        } else if (!this.validator.isWsdlSpec(tModel)) {
            this.result = "failed";
            this.failureDetailMessage = "The tModel key is: [" + tModel.getTModelKey() + "]\n" + "The categoryBag is: [" + this.validator.categoryBagToString(tModel.getCategoryBag()) + "]";
        } else {
            this.validator.setWSDLLocation(this.validator.getWSDLLocation(this.validator.getOverviewURL(tModel)));
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetailMessage);
    }
}

