/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.uddi;

import java.util.Vector;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.binding.BindingTemplate;
import org.uddi4j.datatype.business.BusinessEntity;
import org.uddi4j.datatype.service.BusinessService;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.KeyedReference;
import org.wsi.WSIException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.uddi.UDDIValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.util.UDDIUtils;

public class WSI3007
extends AssertionProcess {
    private final UDDIValidatorImpl validator;

    public WSI3007(UDDIValidatorImpl uDDIValidatorImpl) {
        super(uDDIValidatorImpl);
        this.validator = uDDIValidatorImpl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Object var3_3 = null;
        this.result = "passed";
        BindingTemplate bindingTemplate = (BindingTemplate)entryContext.getEntry().getEntryDetail();
        boolean bl = false;
        boolean bl2 = false;
        String string = null;
        String string2 = null;
        try {
            string = bindingTemplate.getServiceKey();
            BusinessService businessService = UDDIUtils.getBusinessServiceByKey(this.validator.uddiProxy, string);
            string2 = businessService.getBusinessKey();
            BusinessEntity businessEntity = UDDIUtils.getBusinessByKey(this.validator.uddiProxy, string2);
            bl = this.checkCategoryBag(this.validator.uddiProxy, businessService.getCategoryBag());
            bl2 = this.checkCategoryBag(this.validator.uddiProxy, businessEntity.getCategoryBag());
            if (!bl2 || !bl) {
                this.result = "failed";
                if (!bl2) {
                    this.failureDetailMessage = "The businessEntity key is: [" + string2 + "].";
                }
                if (!bl) {
                    this.failureDetailMessage = !bl2 ? this.failureDetailMessage + " " : "";
                    this.failureDetailMessage = this.failureDetailMessage + "The businessService key is: [" + string + "].";
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
            this.result = "failed";
            this.failureDetailMessage = "The UDDI registry does not contain WSI conformance taxonomy tModel (\"ws-i-org:conformsTo:2002_12\").";
        }
        catch (Throwable throwable) {
            throw new WSIException("An exception occurred while processing the discovery test assertions.", throwable);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetailMessage);
    }

    private boolean checkCategoryBag(UDDIProxy uDDIProxy, CategoryBag categoryBag) {
        String string = null;
        try {
            string = UDDIUtils.getWSIConformanceTModelKey(uDDIProxy);
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
        boolean bl = true;
        if (categoryBag != null) {
            Vector vector = categoryBag.getKeyedReferenceVector();
            for (int i = 0; i < vector.size() && bl; ++i) {
                KeyedReference keyedReference = (KeyedReference)vector.get(i);
                bl = !keyedReference.getTModelKey().equalsIgnoreCase(string);
            }
        }
        return bl;
    }
}

