/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.extensions.ExtensibilityElement;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.analyzer.AssertionNotApplicableException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;

public class AP2930
extends AssertionProcess
implements WSITag {
    private final WSDLValidatorImpl validator;

    public AP2930(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            boolean bl = false;
            Binding binding = (Binding)entryContext.getEntry().getEntryDetail();
            List list = binding.getBindingOperations();
            for (int i = 0; i < list.size(); ++i) {
                BindingOperation bindingOperation = (BindingOperation)list.get(i);
                Collection collection = bindingOperation.getBindingFaults().values();
                if (collection.isEmpty()) continue;
                bl = true;
                if (!this.containsMimeMultiparts(collection)) continue;
                throw new AssertionFailException("The binding operation is \"" + bindingOperation.getName() + "\".");
            }
            if (!bl) {
                throw new AssertionNotApplicableException();
            }
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException assertionFailException) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(assertionFailException.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private boolean containsMimeMultiparts(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            List list = ((BindingFault)iterator.next()).getExtensibilityElements();
            for (int i = 0; i < list.size(); ++i) {
                if (!((ExtensibilityElement)list.get(i)).getElementType().equals(WSITag.WSDL_MIME_MULTIPART)) continue;
                return true;
            }
        }
        return false;
    }
}

