/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Output;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.xml.XMLUtils;

public class AP2941
extends AssertionProcess
implements WSITag {
    private final WSDLValidatorImpl validator;

    public AP2941(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            Binding binding = (Binding)entryContext.getEntry().getEntryDetail();
            List list = binding.getBindingOperations();
            for (int i = 0; i < list.size(); ++i) {
                List<String> list2;
                BindingOperation bindingOperation = (BindingOperation)list.get(i);
                Input input = bindingOperation.getOperation().getInput();
                Output output = bindingOperation.getOperation().getOutput();
                if (input != null && input.getMessage() != null && !(list2 = this.getBindingParts(bindingOperation.getBindingInput().getExtensibilityElements(), input.getMessage())).containsAll(input.getMessage().getParts().keySet())) {
                    throw new AssertionFailException("The wsdl:input of the \"" + bindingOperation.getName() + "\" binding operation does not " + "bind all the corresponding wsdl:partS.");
                }
                if (output != null && output.getMessage() != null && !(list2 = this.getBindingParts(bindingOperation.getBindingOutput().getExtensibilityElements(), output.getMessage())).containsAll(output.getMessage().getParts().keySet())) {
                    throw new AssertionFailException("The wsdl:output of the \"" + bindingOperation.getName() + "\" binding operation does not " + "bind all the corresponding wsdl:partS.");
                }
                if (bindingOperation.getOperation().getFaults().isEmpty()) continue;
                list2 = new ArrayList();
                Collection collection = bindingOperation.getBindingFaults().values();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    List list3 = ((BindingFault)iterator.next()).getExtensibilityElements();
                    for (int j = 0; j < list3.size(); ++j) {
                        if (!((ExtensibilityElement)list3.get(j)).getElementType().equals(WSITag.WSDL_SOAP_FAULT)) continue;
                        list2.add(((SOAPFault)list3.get(j)).getName());
                    }
                }
                if (list2.containsAll(bindingOperation.getOperation().getFaults().keySet())) continue;
                throw new AssertionFailException("The binding operation \"" + bindingOperation.getName() + "\" does not " + "bind all the corresponding wsdl:faultS.");
            }
        }
        catch (AssertionFailException assertionFailException) {
            this.result = "warning";
            this.failureDetail = this.validator.createFailureDetail(assertionFailException.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private List getBindingParts(List list, Message message) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                int n;
                List list2;
                ExtensibilityElement extensibilityElement = (ExtensibilityElement)list.get(i);
                if (extensibilityElement.getElementType().equals(WSITag.WSDL_SOAP_BODY)) {
                    list2 = ((SOAPBody)extensibilityElement).getParts();
                    if (list2 != null) {
                        arrayList.addAll(list2);
                        continue;
                    }
                    arrayList.addAll(message.getParts().keySet());
                    continue;
                }
                if (extensibilityElement.getElementType().equals(WSITag.WSDL_SOAP_HEADER)) {
                    Object object;
                    list2 = null;
                    if (extensibilityElement instanceof SOAPHeader) {
                        object = (SOAPHeader)extensibilityElement;
                        if (message.getQName().equals(object.getMessage())) {
                            arrayList.add(object.getPart());
                        }
                        list2 = object.getSOAPHeaderFaults();
                    } else {
                        object = ((UnknownExtensibilityElement)extensibilityElement).getElement();
                        if (this.referencesMessage((Element)object, message.getQName())) {
                            arrayList.add(object.getAttribute("part"));
                        }
                        list2 = this.getHeaderFaults((Element)object);
                    }
                    for (n = 0; n < list2.size(); ++n) {
                        Object object2;
                        if (list2.get(n) instanceof SOAPHeaderFault) {
                            object2 = (SOAPHeaderFault)list2.get(n);
                            if (!message.equals(object2.getMessage())) continue;
                            arrayList.add(object2.getPart());
                            continue;
                        }
                        object2 = (Element)list2.get(n);
                        if (!this.referencesMessage((Element)object2, message.getQName())) continue;
                        arrayList.add(object2.getAttribute("part"));
                    }
                    continue;
                }
                if (extensibilityElement.getElementType().equals(WSITag.WSDL_MIME_CONTENT)) {
                    arrayList.add(((MIMEContent)extensibilityElement).getPart());
                    continue;
                }
                if (!extensibilityElement.getElementType().equals(WSITag.WSDL_MIME_MULTIPART)) continue;
                list2 = ((MIMEMultipartRelated)extensibilityElement).getMIMEParts();
                for (n = 0; n < list2.size(); ++n) {
                    arrayList.addAll(this.getBindingParts(((MIMEPart)list2.get(n)).getExtensibilityElements(), message));
                }
            }
        }
        return arrayList;
    }

    private boolean referencesMessage(Element element, QName qName) {
        String string;
        String string2 = element.getAttribute("message");
        int n = string2.indexOf(":");
        String string3 = null;
        String string4 = string = n > -1 ? string2.substring(n + 1) : string2;
        if (n > -1) {
            string3 = this.validator.wsdlDocument.getDefinitions().getNamespace(string2.substring(0, n));
        }
        return qName.getLocalPart().equals(string) && qName.getNamespaceURI().equals(string3);
    }

    private List getHeaderFaults(Element element) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        if (element != null) {
            Element element2 = XMLUtils.getFirstChild(element);
            while (element2 != null) {
                if (element2.getNamespaceURI().equals(WSITag.WSDL_SOAP_HEADERFAULT.getNamespaceURI()) && element2.getLocalName().equals(WSITag.WSDL_SOAP_HEADERFAULT.getLocalPart())) {
                    arrayList.add(element2);
                }
                element2 = XMLUtils.getNextSibling(element2);
            }
        }
        return arrayList;
    }
}

