/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import java.util.ArrayList;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.analyzer.AssertionNotApplicableException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;

public class AP2944
extends AssertionProcess
implements WSITag {
    private final WSDLValidatorImpl validator;
    private boolean mimeContentFound;

    public AP2944(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.mimeContentFound = false;
        try {
            Binding binding = (Binding)entryContext.getEntry().getEntryDetail();
            List list = binding.getBindingOperations();
            for (int i = 0; i < list.size(); ++i) {
                MIMEContent mIMEContent;
                Input input;
                BindingOperation bindingOperation = (BindingOperation)list.get(i);
                BindingInput bindingInput = bindingOperation.getBindingInput();
                BindingOutput bindingOutput = bindingOperation.getBindingOutput();
                List list2 = this.getMimeContentElements(bindingInput == null ? null : bindingInput.getExtensibilityElements());
                List list3 = this.getMimeContentElements(bindingOutput == null ? null : bindingOutput.getExtensibilityElements());
                if (!list2.isEmpty() && (input = bindingOperation.getOperation().getInput()) != null && input.getMessage() != null && (mIMEContent = this.getInvalidMimeContent(list2, input.getMessage())) != null) {
                    throw new AssertionFailException("The mime:content element in the wsdl:input of the \"" + bindingOperation.getName() + "\" that binds the \"" + mIMEContent.getPart() + "\" wsdl:part uses the invalid content type \"" + mIMEContent.getType() + "\". ");
                }
                if (list3.isEmpty() || (input = bindingOperation.getOperation().getOutput()) == null || input.getMessage() == null || (mIMEContent = this.getInvalidMimeContent(list3, input.getMessage())) == null) continue;
                throw new AssertionFailException("The mime:content element in the wsdl:output of the \"" + bindingOperation.getName() + "\" that binds the \"" + mIMEContent.getPart() + "\" wsdl:part uses the invalid content type \"" + mIMEContent.getType() + "\". ");
            }
            if (!this.mimeContentFound) {
                throw new AssertionNotApplicableException();
            }
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException assertionFailException) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(assertionFailException.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private MIMEContent getInvalidMimeContent(List list, Message message) {
        for (int i = 0; i < list.size(); ++i) {
            MIMEContent mIMEContent = (MIMEContent)list.get(i);
            Part part = message.getPart(mIMEContent.getPart());
            if (part == null || part.getElementName() == null) continue;
            this.mimeContentFound = true;
            if ("text/xml".equals(mIMEContent.getType())) continue;
            return mIMEContent;
        }
        return null;
    }

    private List getMimeContentElements(List list) {
        ArrayList<ExtensibilityElement> arrayList = new ArrayList<ExtensibilityElement>();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                ExtensibilityElement extensibilityElement = (ExtensibilityElement)list.get(i);
                if (extensibilityElement.getElementType().equals(WSITag.WSDL_MIME_MULTIPART)) {
                    List list2 = ((MIMEMultipartRelated)extensibilityElement).getMIMEParts();
                    for (int j = 0; j < list2.size(); ++j) {
                        List list3 = this.getMimeContentElements(((MIMEPart)list2.get(j)).getExtensibilityElements());
                        arrayList.addAll(list3);
                    }
                    continue;
                }
                if (!extensibilityElement.getElementType().equals(WSITag.WSDL_MIME_CONTENT)) continue;
                arrayList.add(extensibilityElement);
            }
        }
        return arrayList;
    }
}

