/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import javax.wsdl.Binding;
import org.wsi.WSIException;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;

public class BP2012
extends AssertionProcess {
    private final WSDLValidatorImpl validator;

    public BP2012(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Binding binding = (Binding)entryContext.getEntry().getEntryDetail();
        WSDLValidatorImpl.BindingMatch[] bindingMatchArray = this.validator.getBindingMatches(binding, "document", "literal");
        if (bindingMatchArray.length == 0) {
            this.result = "notApplicable";
        } else {
            try {
                if (!this.validator.checkPartAttributes(bindingMatchArray, "useInput", "useElement") || !this.validator.checkPartAttributes(bindingMatchArray, "useOutput", "useElement")) {
                    throw new AssertionFailException("diagnostic: internal processing error!");
                }
            }
            catch (AssertionFailException assertionFailException) {
                this.result = "failed";
                this.failureDetail = this.validator.createFailureDetail(assertionFailException.getMessage(), entryContext, binding);
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

