/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Types;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import org.wsi.WSIException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;

public class BP2034
extends AssertionProcess {
    private final WSDLValidatorImpl validator;

    public BP2034(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Definition definition = (Definition)entryContext.getEntry().getEntryDetail();
        String string = (String)definition.getNamespaces().get("xml");
        if (string != null && string.equals("http://www.w3.org/XML/1998/namespace")) {
            this.result = "warning";
        } else {
            Types types = definition.getTypes();
            if (types != null) {
                List list = types.getExtensibilityElements();
                for (int i = 0; i < list.size(); ++i) {
                    UnknownExtensibilityElement unknownExtensibilityElement = (UnknownExtensibilityElement)list.get(i);
                    String string2 = unknownExtensibilityElement.getElement().getAttributeNS("http://www.w3.org/2000/xmlns/", "xml");
                    if (!"http://www.w3.org/XML/1998/namespace".equals(string2)) continue;
                    this.result = "warning";
                    this.failureDetail = this.validator.createFailureDetail("The namespace declaration nested in wsdl:schema element.", entryContext);
                    break;
                }
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

